package de.pfabulist.jlot;

import de.pfabulist.roast.collection.Mapp;
import de.pfabulist.roast.functiontypes.Supplierr;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

import static de.pfabulist.roast.NonnullCheck._nn;
import static de.pfabulist.roast.unchecked.Unchecked.u;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LotDescription {

    private Set<String> notSupportedTags = new HashSet<>();
    private Set<String> disabledMethods = new HashSet<>();
    private Mapp<String, Once<?>> shared = new Mapp<>();

    public boolean isTagSupported( String tag ) {
        return !notSupportedTags.contains( tag );
    }

    public boolean isTagSupported( Class<?> tag ) {
        return !notSupportedTags.contains( tag.getSimpleName() );
    }

    public boolean isDisabled( String testName ) {
        return disabledMethods.contains( testName );
    }

    public void removeTag( Class clazz ) {
        notSupportedTags.add( clazz.getSimpleName() );
    }

    public void disableMethod( Class<?> clazz, String methodName ) {
        try {
            clazz.getDeclaredMethod( methodName );
            disabledMethods.add( methodName /* + "()" */ );
        } catch( NoSuchMethodException e ) {
            throw _nn(u(e));
        }
    }

    public void addTag( Class<?> clazz ) {
        notSupportedTags.remove( clazz.getSimpleName() );
    }

    public <T> Once<T> getStorage( String name, Class<T> clazz ) {
        if ( !shared.containsKey( name )) {
            shared.put( name, new Once<>() );
        }

        return (Once<T>) shared.getOrThrow( name );
    }

    public <T> T getItemSpecificValue( String name, Class<T> clazz, Supplierr<T> sup ) {
        if ( !shared.containsKey( name )) {
            shared.put( name, new Once<>() );
        }

        return ((Once<T>) shared.getOrThrow( name )).get( sup );
    }
}
