package de.pfabulist.jlot;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

import static org.junit.jupiter.api.Assumptions.assumeFalse;
import static org.junit.jupiter.api.Assumptions.assumeTrue;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public abstract class JLot<T extends LotDescription> {

    private String testName = "ihavenoidea";

    @BeforeEach
    void init( TestInfo testInfo ) {
        TestInfoo ti = TestInfoo.of( testInfo );

        // filter tests that don't support all @Tags from this method
        ti.getTags().forEach( t -> assumeTrue( descr().isTagSupported( t ) ) );

        // filter tests that are named as isDisabled
        testName = ti.getDisplayName().substring( 0, ti.getDisplayName().length() - 2 );

        assumeFalse( descr().isDisabled( testName ));
    }

    public String getTestName() {
        return testName;
    }

    public abstract T descr();

}
