/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.elsewhere;

import de.pfabulist.elsewhere.Elsewhere;
import de.pfabulist.elsewhere.Result;
import de.pfabulist.kleinod.paths.Filess;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FSElsewhere
implements Elsewhere {
    private final Path root;

    public FSElsewhere(Path root) {
        this.root = root;
    }

    @Override
    public Result put(String id, InputStream is) {
        if (!this.connected()) {
            return Result.ELSEWHEREGONE;
        }
        Path host = this.getHost(id);
        Filess.createDirectories((Path)host);
        Filess.copy((InputStream)is, (Path)host);
        return Result.ONE;
    }

    @Override
    public Result get(String id, OutputStream os) {
        if (!this.connected()) {
            return Result.ELSEWHEREGONE;
        }
        Filess.copy((Path)this.getHost(id), (OutputStream)os);
        return Result.ONE;
    }

    @Override
    public boolean contains(String id) {
        return Files.exists(this.getHost(id), new LinkOption[0]);
    }

    @Override
    public Result remove(String id) {
        if (!this.connected()) {
            return Result.ELSEWHEREGONE;
        }
        if (!this.contains(id)) {
            return Result.NONE;
        }
        Filess.deleteIfExists((Path)this.getHost(id));
        return Result.ONE;
    }

    @Override
    public boolean connected() {
        return Files.exists(this.root, new LinkOption[0]);
    }

    private Path getHost(String id) {
        Path ret = this.root;
        for (String part : id.split("-")) {
            ret = ret.resolve(id);
        }
        return ret;
    }
}

