/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.bigchin;

import de.pfabulist.bigchin.Env;
import de.pfabulist.bigchin.Thing;
import java.util.Objects;

public class Symbol
implements Thing {
    private final String sym;

    public Symbol(String sym) {
        this.sym = sym;
        if (sym.length() == 0 || sym.charAt(0) == '@') {
            throw new IllegalStateException("cant Symbol " + sym);
        }
    }

    public String toString() {
        return this.sym;
    }

    @Override
    public Thing eval(Env env) {
        return env.eval(this.sym);
    }

    public static Symbol n(String sym) {
        return new Symbol(sym);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return Objects.equals(this.sym, symbol.sym);
    }

    public int hashCode() {
        return Objects.hash(this.sym);
    }
}

