/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.bigchin;

import de.pfabulist.bigchin.BIConstant;
import de.pfabulist.bigchin.Bool;
import de.pfabulist.bigchin.Env;
import de.pfabulist.bigchin.Exc;
import de.pfabulist.bigchin.Lambda;
import de.pfabulist.bigchin.Lazy;
import de.pfabulist.bigchin.LazyStream;
import de.pfabulist.bigchin.Lbd;
import de.pfabulist.bigchin.Lst;
import de.pfabulist.bigchin.Null;
import de.pfabulist.bigchin.Number;
import de.pfabulist.bigchin.Stream;
import de.pfabulist.bigchin.Thing;
import de.pfabulist.bigchin.biglist.BigList;
import de.pfabulist.bigchin.biglist.BigListFirst;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class Ray
implements Stream,
Lbd {
    private List<RayBlock> blocks = new ArrayList<RayBlock>();
    private Stream startStream;
    private Env env;

    @Override
    public Thing exec(BigList<Thing> res) {
        if (res.getSize().compareTo(BIConstant.BI_1) != 0 || !(res.getOrThrow(0) instanceof Number)) {
            return new Exc("a ray needs a Number arg");
        }
        return this.get(((Number)res.getOrThrow((int)0)).bi);
    }

    @Override
    public BigInteger getArgumentCount() {
        return BIConstant.BI_1;
    }

    public Ray(Env env, BigList<Thing> args) {
        this.env = env;
        Thing prest = ((Thing)args.getOrThrow(0)).eval(env);
        if (!(prest instanceof Ray || prest instanceof Lbd || prest instanceof Lst)) {
            throw new IllegalStateException("ray missing, got: " + prest);
        }
        this.blocks.add(new RayBlock());
        this.blocks.get((int)0).streamIdx = BIConstant.BI_0;
        this.startStream = prest instanceof Stream ? (Stream)prest : new LazyStream(env, (Lbd)prest);
        for (int idx = 1; idx < args.getSize().intValueExact(); ++idx) {
            RayBlock nextBlock = new RayBlock();
            if (!(args.getOrThrow(idx) instanceof Lst)) {
                throw new IllegalStateException("ray: not a Lst: " + args.getOrThrow(idx));
            }
            Lst cmd = (Lst)args.getOrThrow(idx);
            if (cmd.size().compareTo(BIConstant.BI_2) != 0 || !(cmd.get(BIConstant.BI_0) instanceof Lazy)) {
                throw new IllegalStateException("just commands cmds not: " + args.getOrThrow(idx));
            }
            nextBlock.cmd = (Lazy)cmd.get(BIConstant.BI_0);
            nextBlock.todo = (Lbd)cmd.get(BIConstant.BI_1).eval(env);
            this.blocks.add(nextBlock);
        }
    }

    @Override
    public Thing get(BigInteger target) {
        boolean streamRunning = true;
        while (streamRunning && this.blocks.get((int)(this.blocks.size() - 1)).preStream.getSize().compareTo(target) <= 0) {
            boolean cmdRunning = true;
            Thing current = this.startStream.get(this.blocks.get((int)0).streamIdx);
            block13: for (int idx = 1; this.blocks.size() > idx && cmdRunning; ++idx) {
                RayBlock oldBlock = this.blocks.get(idx - 1);
                RayBlock nowBlock = this.blocks.get(idx);
                Thing cmdRes = this.executeCmd(this.env, nowBlock.todo, current, nowBlock.size(), nowBlock.preStream, oldBlock.size());
                switch (nowBlock.cmd.toString()) {
                    case ":filter": {
                        Bool takep = (Bool)cmdRes;
                        if (takep.is()) {
                            this.blocks.set(idx, nowBlock.add(current));
                            continue block13;
                        }
                        cmdRunning = false;
                        continue block13;
                    }
                    case ":while": {
                        Bool takep = (Bool)cmdRes;
                        if (!takep.is()) {
                            streamRunning = false;
                            continue block13;
                        }
                        this.blocks.set(idx, nowBlock.add(current));
                        continue block13;
                    }
                    case ":map": {
                        this.blocks.set(idx, nowBlock.add(cmdRes));
                        current = cmdRes;
                        continue block13;
                    }
                    case ":find": {
                        if (((Bool)cmdRes).is()) {
                            this.blocks.set(idx, nowBlock.add(current));
                            streamRunning = false;
                        }
                        cmdRunning = false;
                        continue block13;
                    }
                    default: {
                        throw new IllegalStateException("no " + nowBlock.cmd);
                    }
                }
            }
            this.blocks.get((int)0).streamIdx = this.blocks.get((int)0).streamIdx.add(BIConstant.BI_1);
        }
        if (this.blocks.size() == 1) {
            throw new IllegalStateException("not yet");
        }
        if (target.compareTo(this.blocks.get((int)(this.blocks.size() - 1)).preStream.getSize()) < 0) {
            return (Thing)this.blocks.get((int)(this.blocks.size() - 1)).preStream.getOrThrow(target);
        }
        return new Exc("no idx");
    }

    @Override
    public boolean has(BigInteger stridx) {
        return !(this.get(stridx) instanceof Exc);
    }

    @Override
    public Thing eval(Env env) {
        return this;
    }

    public String toString() {
        return "Ray{}";
    }

    private boolean isBar(Lbd lbd, int idx) {
        return lbd instanceof Lambda && !((Lambda)lbd).isUsed(idx);
    }

    private Thing executeCmd(Env env, Lbd lbd, Thing streamElement, BigInteger stridx, BigList<Thing> prestream, BigInteger beforeSize) {
        if (lbd.getArgumentCount().compareTo(BIConstant.BI_0) == 0) {
            throw new IllegalStateException("when");
        }
        BigListFirst args = new BigListFirst();
        args = args.add((Object)streamElement);
        if (lbd.getArgumentCount().compareTo(BIConstant.BI_1) == 0) {
            return lbd.exec((BigList<Thing>)args);
        }
        args = args.add((Object)Number.n("" + stridx));
        if (lbd.getArgumentCount().compareTo(BIConstant.BI_2) == 0) {
            return lbd.exec((BigList<Thing>)args);
        }
        args = this.isBar(lbd, 2) ? args.add((Object)Null.n()) : args.add((Object)Lst.n(prestream));
        if (lbd.getArgumentCount().compareTo(BIConstant.BI_3) == 0) {
            return lbd.exec((BigList<Thing>)args);
        }
        args = this.isBar(lbd, 3) ? args.add((Object)Null.n()) : args.add((Object)Number.n("" + beforeSize));
        if (lbd.getArgumentCount().compareTo(BIConstant.BI_4) == 0) {
            return lbd.exec((BigList<Thing>)args);
        }
        throw new IllegalStateException("no before yet: " + lbd);
    }

    private static class RayBlock {
        public BigList<Thing> preStream = new BigListFirst();
        public BigInteger streamIdx = BIConstant.BI_M_1;
        public Lazy cmd;
        public Lbd todo;

        private RayBlock() {
        }

        public RayBlock add(Thing current) {
            RayBlock ret = new RayBlock();
            ret.preStream = this.preStream.add((Object)current);
            ret.streamIdx = this.streamIdx;
            ret.cmd = this.cmd;
            ret.todo = this.todo;
            return ret;
        }

        public BigInteger size() {
            if (this.streamIdx.signum() >= 0) {
                return this.streamIdx;
            }
            return this.preStream.getSize();
        }
    }
}

