/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.bigchin;

import de.pfabulist.bigchin.BIConstant;
import de.pfabulist.bigchin.Bool;
import de.pfabulist.bigchin.Env;
import de.pfabulist.bigchin.Lbd;
import de.pfabulist.bigchin.Number;
import de.pfabulist.bigchin.Thing;
import de.pfabulist.bigchin.biglist.BigList;
import java.math.BigInteger;
import java.util.Map;

public class NumberLambda
implements Lbd {
    private final String name;

    public NumberLambda(String name) {
        this.name = name;
    }

    public static void addLambdas(Map<String, Thing> map) {
        map.put("+", new NumberLambda("+"));
        map.put("-", new NumberLambda("-"));
        map.put("remainder", new NumberLambda("remainder"));
        map.put(">", new NumberLambda(">"));
        map.put("<", new NumberLambda("<"));
        map.put("<=", new NumberLambda("<="));
        map.put("*", new NumberLambda("*"));
    }

    @Override
    public Thing exec(BigList<Thing> res) {
        switch (this.name) {
            case "+": {
                return this.n(res, BIConstant.BI_0).plus(this.n(res, BIConstant.BI_1));
            }
            case "*": {
                return this.n(res, BIConstant.BI_0).times(this.n(res, BIConstant.BI_1));
            }
            case "-": {
                return this.n(res, BIConstant.BI_0).minus(this.n(res, BIConstant.BI_1));
            }
            case ">": {
                return this.n(res, BIConstant.BI_0).greater(this.n(res, BIConstant.BI_1));
            }
            case "<": {
                return this.n(res, BIConstant.BI_1).greater(this.n(res, BIConstant.BI_0));
            }
            case "<=": {
                return new Bool(this.n(res, BIConstant.BI_0).compareTo(this.n(res, BIConstant.BI_1)) < 1);
            }
            case "remainder": {
                return this.n(res, BIConstant.BI_0).remainder(this.n(res, BIConstant.BI_1));
            }
        }
        throw new IllegalStateException("unknown ldb" + this.name);
    }

    public Number n(BigList<Thing> res, BigInteger idx) {
        if (res.getSize().compareTo(idx) <= 0) {
            throw new IllegalStateException("need more arguments: " + this.name + ", " + idx);
        }
        Thing ret = (Thing)res.getOrThrow(idx);
        if (ret instanceof Number) {
            return (Number)ret;
        }
        throw new IllegalStateException("not a number arguments: " + this.name + ", " + ret);
    }

    @Override
    public BigInteger getArgumentCount() {
        return BIConstant.BI_2;
    }

    @Override
    public Thing eval(Env env) {
        return this;
    }
}

