/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.bigchin;

import de.pfabulist.bigchin.BIConstant;
import de.pfabulist.bigchin.Env;
import de.pfabulist.bigchin.Exc;
import de.pfabulist.bigchin.Lbd;
import de.pfabulist.bigchin.Lst;
import de.pfabulist.bigchin.Number;
import de.pfabulist.bigchin.Thing;
import de.pfabulist.bigchin.biglist.BigList;
import java.math.BigInteger;
import java.util.Map;

public class ListLbd
implements Lbd {
    private final String name;

    public ListLbd(String name) {
        this.name = name;
    }

    public static void addLambdas(Map<String, Thing> map) {
        map.put("list", new ListLbd("list"));
        map.put("rget", new ListLbd("rget"));
    }

    @Override
    public Thing exec(BigList<Thing> res) {
        switch (this.name) {
            case "list": {
                return Lst.n(res);
            }
            case "rget": {
                Lst lst = this.n(res, BIConstant.BI_0);
                BigInteger size = lst.size();
                BigInteger idx = ((Number)res.getOrThrow((int)1)).bi;
                BigInteger realIdx = size.subtract(BIConstant.BI_1).subtract(idx);
                if (realIdx.compareTo(size) >= 0 || realIdx.signum() < 0) {
                    return new Exc("rget bad idx " + idx);
                }
                return lst.get(size.subtract(BIConstant.BI_1).subtract(idx));
            }
        }
        throw new IllegalStateException("unknown ldb" + this.name);
    }

    private Lst n(BigList<Thing> res, BigInteger idx) {
        if (res.getSize().compareTo(idx) <= 0) {
            throw new IllegalStateException("need more arguments: " + this.name + ", " + idx);
        }
        Thing ret = (Thing)res.getOrThrow(idx);
        if (ret instanceof Lst) {
            return (Lst)ret;
        }
        throw new IllegalStateException("not a number arguments: " + this.name + ", " + ret);
    }

    @Override
    public BigInteger getArgumentCount() {
        switch (this.name) {
            case "list": {
                return BIConstant.BI_M_1;
            }
            case "rget": {
                return BIConstant.BI_2;
            }
        }
        return BIConstant.BI_0;
    }

    @Override
    public Thing eval(Env env) {
        return this;
    }
}

