/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.bigchin;

import de.pfabulist.bigchin.Env;
import de.pfabulist.bigchin.Lbd;
import de.pfabulist.bigchin.Thing;
import de.pfabulist.bigchin.biglist.BigList;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Lambda
implements Lbd {
    private final BigList<String> names;
    private final Thing body;
    private final Env env;

    public Lambda(Env env, Thing body, BigList<String> names) {
        this.names = names;
        this.body = body;
        this.env = env;
    }

    public String toString() {
        return "(!lbd (" + this.names.stream().collect(Collectors.joining(" ")) + ") " + this.body + ")";
    }

    @Override
    public Thing eval(Env env) {
        return this;
    }

    @Override
    public Thing exec(BigList<Thing> res) {
        HashMap<String, Thing> next = new HashMap<String, Thing>();
        BigInteger i = BigInteger.ZERO;
        while (i.compareTo(this.names.getSize()) < 0) {
            if (!((String)this.names.getOrThrow(i)).equals("_")) {
                next.put((String)this.names.getOrThrow(i), (Thing)res.getOrThrow(i));
            }
            i = i.add(BigInteger.ONE);
        }
        Env exectime = this.env.next(next);
        return this.body.eval(exectime);
    }

    @Override
    public BigInteger getArgumentCount() {
        return this.names.getSize();
    }

    public boolean isUsed(int idx) {
        return !((String)this.names.getOrThrow(idx)).equals("_");
    }
}

