/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.bigchin;

import de.pfabulist.bigchin.Bool;
import de.pfabulist.bigchin.Env;
import de.pfabulist.bigchin.Lbd;
import de.pfabulist.bigchin.Lst;
import de.pfabulist.bigchin.Null;
import de.pfabulist.bigchin.Strng;
import de.pfabulist.bigchin.Thing;
import de.pfabulist.bigchin.biglist.BigList;
import java.math.BigInteger;
import java.util.stream.Collectors;

public class Home
implements Lbd {
    private final String name;

    public Home(String name) {
        this.name = name;
    }

    @Override
    public Thing exec(BigList<Thing> res) {
        switch (this.name) {
            case "++": {
                return new Strng(res.stream().map(x -> ((Strng)x).get()).collect(Collectors.joining("")));
            }
            case "list": {
                return Lst.n(res);
            }
            case "empty?": {
                return new Bool(((Lst)res.getOrThrow(0)).size().signum() == 0);
            }
            case "not": {
                return new Bool(!((Bool)res.getOrThrow(0)).is());
            }
            case "print": {
                System.out.println(res);
                return !res.isEmpty() ? (Thing)res.getOrThrow(0) : Null.n();
            }
            case "==": {
                if (res.getSize().compareTo(BigInteger.valueOf(2L)) != 0) {
                    throw new IllegalStateException("== got " + res.getSize());
                }
                Thing left = (Thing)res.getOrThrow(0);
                Thing right = (Thing)res.getOrThrow(1);
                return new Bool(left.equals(right));
            }
        }
        throw new IllegalStateException("not");
    }

    @Override
    public BigInteger getArgumentCount() {
        switch (this.name) {
            case "++": {
                return BigInteger.valueOf(2L);
            }
            case "+": {
                return BigInteger.valueOf(2L);
            }
            case ">": {
                return BigInteger.valueOf(2L);
            }
            case "remainder": {
                return BigInteger.valueOf(2L);
            }
            case "list": {
                return BigInteger.ZERO;
            }
            case "==": {
                return BigInteger.valueOf(2L);
            }
        }
        throw new IllegalStateException("argument count, no home");
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Thing eval(Env env) {
        return this;
    }

    @Override
    public boolean isFunction() {
        return true;
    }
}

