/*
 * Decompiled with CFR 0.152.
 */
package de.petendi.commons.crypto;

import org.cryptonode.jncryptor.AES256JNCryptor;
import org.cryptonode.jncryptor.CryptorException;
import org.cryptonode.jncryptor.JNCryptor;

public class SymmetricCrypto {
    private JNCryptor cryptor;

    public SymmetricCrypto() {
        this((JNCryptor)new AES256JNCryptor());
    }

    protected SymmetricCrypto(JNCryptor cryptor) {
        this.cryptor = cryptor;
    }

    public byte[] decrypt(byte[] encrypted, char[] password) {
        byte[] plainText;
        try {
            plainText = this.cryptor.decryptData(encrypted, password);
        }
        catch (CryptorException e) {
            throw new IllegalStateException(e);
        }
        return plainText;
    }

    public byte[] encrypt(byte[] plaintext, char[] password) {
        byte[] ciphertext;
        try {
            ciphertext = this.cryptor.encryptData(plaintext, password);
        }
        catch (CryptorException e) {
            throw new IllegalStateException(e);
        }
        return ciphertext;
    }
}

