/*
 * Decompiled with CFR 0.152.
 */
package de.petendi.commons.crypto;

import de.petendi.commons.crypto.BaseAsymmetric;
import de.petendi.commons.crypto.connector.SecurityProviderConnector;
import java.io.InputStream;
import java.io.Reader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public class Signature
extends BaseAsymmetric {
    public Signature(SecurityProviderConnector securityProviderConnector) {
        super(securityProviderConnector);
    }

    public Signature(SecurityProviderConnector securityProviderConnector, String privateKeyEntry) {
        super(securityProviderConnector, privateKeyEntry);
    }

    public byte[] sign(byte[] input, char[] password, InputStream pkcs12Stream) {
        try {
            PrivateKey privateKey = this.extractPrivateKey(password, pkcs12Stream);
            return this.signInternal(input, privateKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] sign(byte[] input, PrivateKey privateKey) {
        try {
            return this.signInternal(input, privateKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private byte[] signInternal(byte[] input, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        java.security.Signature signature = java.security.Signature.getInstance(this.securityProviderConnector.getSignAlgorithm(), this.securityProviderConnector.getProviderName());
        signature.initSign(privateKey);
        signature.update(input);
        return signature.sign();
    }

    public boolean verify(byte[] input, byte[] signature, PublicKey publicKey) {
        try {
            return this.verifyInternal(input, signature, publicKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean verify(byte[] input, byte[] signature, Reader pemReader) {
        try {
            PublicKey publicKey = this.extractPublicKey(pemReader);
            return this.verifyInternal(input, signature, publicKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean verifyInternal(byte[] input, byte[] signature, PublicKey publicKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        java.security.Signature mySignature = java.security.Signature.getInstance(this.securityProviderConnector.getSignAlgorithm(), this.securityProviderConnector.getProviderName());
        mySignature.initVerify(publicKey);
        mySignature.update(input);
        return mySignature.verify(signature);
    }
}

