/*
 * Decompiled with CFR 0.152.
 */
package de.petendi.commons.crypto;

import de.petendi.commons.crypto.AsymmetricCrypto;
import de.petendi.commons.crypto.Signature;
import de.petendi.commons.crypto.SymmetricCrypto;
import de.petendi.commons.crypto.connector.SecurityProviderConnector;
import de.petendi.commons.crypto.model.HybridEncrypted;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class HybridCrypto {
    private byte[] symmetricPassPhrase = null;
    private HybridEncrypted encryptedMessage = new HybridEncrypted();
    private SymmetricCrypto symmetricCrypto = new SymmetricCrypto();
    private AsymmetricCrypto asymmetricCrypto;
    private final SecurityProviderConnector securityProviderConnector;

    public HybridCrypto(SecurityProviderConnector securityProviderConnector) {
        this.securityProviderConnector = securityProviderConnector;
        this.asymmetricCrypto = new AsymmetricCrypto(securityProviderConnector);
        this.encryptedMessage.setHeaders(new HashMap<String, String>());
        this.encryptedMessage.setRecipients(new HashMap<String, byte[]>());
        this.encryptedMessage.setCertificates(new HashMap<String, String>());
    }

    private synchronized void createSymmetricPassphrase() {
        if (this.symmetricPassPhrase == null) {
            this.symmetricPassPhrase = this.securityProviderConnector.generateSecretKey().getEncoded();
        }
    }

    public HybridCrypto addRecipient(String recipientIdentifier, Reader pemReader) {
        try {
            this.createSymmetricPassphrase();
            String certificate = IOUtils.toString((Reader)pemReader);
            byte[] encryptedPassPhrase = this.asymmetricCrypto.encrypt(this.symmetricPassPhrase, new StringReader(certificate));
            this.encryptedMessage.getRecipients().put(recipientIdentifier, encryptedPassPhrase);
            this.encryptedMessage.getCertificates().put(recipientIdentifier, certificate);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public HybridCrypto addRecipient(String recipientIdentifier, X509Certificate certificate) {
        try {
            this.createSymmetricPassphrase();
            byte[] encryptedPassPhrase = this.asymmetricCrypto.encrypt(this.symmetricPassPhrase, certificate.getPublicKey());
            this.encryptedMessage.getRecipients().put(recipientIdentifier, encryptedPassPhrase);
            StringWriter pemWriter = new StringWriter();
            this.securityProviderConnector.writeCertificate(pemWriter, certificate);
            this.encryptedMessage.getCertificates().put(recipientIdentifier, pemWriter.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public HybridEncrypted build(byte[] message, char[] signPassword, InputStream pkcs12Stream) {
        byte[] encryptedBody = this.encryptInternal(message);
        Signature signature = new Signature(this.securityProviderConnector);
        byte[] signed = signature.sign(encryptedBody, signPassword, pkcs12Stream);
        this.encryptedMessage.setSignature(signed);
        return this.encryptedMessage;
    }

    public HybridEncrypted build(byte[] message, PrivateKey privateKey) {
        byte[] encryptedBody = this.encryptInternal(message);
        Signature signature = new Signature(this.securityProviderConnector);
        byte[] signed = signature.sign(encryptedBody, privateKey);
        this.encryptedMessage.setSignature(signed);
        return this.encryptedMessage;
    }

    private byte[] encryptInternal(byte[] message) {
        this.createSymmetricPassphrase();
        char[] base64PassPhrase = Base64.encodeBase64String((byte[])this.symmetricPassPhrase).toCharArray();
        byte[] encryptedBody = this.symmetricCrypto.encrypt(message, base64PassPhrase);
        this.encryptedMessage.setEncryptedBody(encryptedBody);
        return encryptedBody;
    }

    public byte[] decrypt(HybridEncrypted encrypted, String recipientIdentifier, char[] password, InputStream pkcs12Stream) {
        byte[] encryptedPassphrase = encrypted.getRecipients().get(recipientIdentifier);
        char[] chars = this.retrievePassPhrase(encryptedPassphrase, password, pkcs12Stream);
        return this.symmetricCrypto.decrypt(encrypted.getEncryptedBody(), chars);
    }

    public byte[] decrypt(HybridEncrypted encrypted, String recipientIdentifier, PrivateKey privateKey) {
        byte[] encryptedPassphrase = encrypted.getRecipients().get(recipientIdentifier);
        char[] chars = this.retrievePassPhrase(encryptedPassphrase, privateKey);
        return this.symmetricCrypto.decrypt(encrypted.getEncryptedBody(), chars);
    }

    private char[] retrievePassPhrase(byte[] encryptedPassphrase, PrivateKey privateKey) {
        byte[] passPhrase = this.asymmetricCrypto.decrypt(encryptedPassphrase, privateKey);
        byte[] base64Passphrase = Base64.encodeBase64((byte[])passPhrase);
        return new String(base64Passphrase).toCharArray();
    }

    private char[] retrievePassPhrase(byte[] encryptedPassphrase, char[] password, InputStream pkcs12Stream) {
        byte[] passPhrase = this.asymmetricCrypto.decrypt(encryptedPassphrase, password, pkcs12Stream);
        byte[] base64Passphrase = Base64.encodeBase64((byte[])passPhrase);
        return new String(base64Passphrase).toCharArray();
    }
}

