/*
 * Decompiled with CFR 0.152.
 */
package de.petendi.commons.crypto;

import de.petendi.commons.crypto.connector.SecurityProviderConnector;
import java.io.OutputStream;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public final class Certificates {
    private String issuer;
    private String privateKeyEntry;
    private String crlUri;
    private final SecurityProviderConnector securityProviderConnector;

    public Certificates(SecurityProviderConnector securityProviderConnector) {
        this(securityProviderConnector, "issuer");
    }

    public Certificates(SecurityProviderConnector securityProviderConnector, String issuer) {
        this(securityProviderConnector, issuer, "private-key", null);
    }

    public Certificates(SecurityProviderConnector securityProviderConnector, String issuer, String privateKeyEntry, String crlUri) {
        this.securityProviderConnector = securityProviderConnector;
        this.issuer = issuer;
        this.privateKeyEntry = privateKeyEntry;
        this.crlUri = crlUri;
    }

    public X509Certificate create(String userId, KeyStore keyStore) {
        if (keyStore == null) {
            throw new IllegalArgumentException("no keyStore given");
        }
        return this.create(userId, null, keyStore, null);
    }

    private X509Certificate create(String userId, Writer pemWriter, KeyStore keyStore, char[] password) {
        return this.create(userId, password, pemWriter, null, keyStore);
    }

    public X509Certificate create(String userId, char[] password, Writer pemWriter, OutputStream pkcs12Output) {
        if (pkcs12Output == null) {
            throw new IllegalArgumentException("no stream for pkcs12 given");
        }
        return this.create(userId, password, pemWriter, pkcs12Output, null);
    }

    private X509Certificate createCertificate(String dn, String issuer, String crlUri, PublicKey publicKey, PrivateKey privateKey) {
        try {
            return this.securityProviderConnector.createCertificate(dn, issuer, crlUri, publicKey, privateKey);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private X509Certificate create(String userId, char[] password, Writer pemWriter, OutputStream pkcs12Output, KeyStore keyStore) {
        X509Certificate selfCert;
        if (userId == null) {
            throw new IllegalArgumentException("userId must not be null");
        }
        try {
            KeyStore keyStoreToUse;
            KeyPair keyPair = this.securityProviderConnector.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            selfCert = this.createCertificate("CN=" + userId, "CN=" + this.issuer, this.crlUri, publicKey, privateKey);
            Certificate[] outChain = new Certificate[]{selfCert};
            if (pemWriter != null) {
                this.securityProviderConnector.writeCertificate(pemWriter, selfCert);
            }
            if (keyStore == null) {
                keyStoreToUse = KeyStore.getInstance("PKCS12", this.securityProviderConnector.getProviderName());
                keyStoreToUse.load(null, password);
            } else {
                keyStoreToUse = keyStore;
            }
            keyStoreToUse.setKeyEntry(this.privateKeyEntry, privateKey, password, outChain);
            if (pkcs12Output != null) {
                keyStoreToUse.store(pkcs12Output, password);
                pkcs12Output.flush();
                pkcs12Output.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return selfCert;
    }
}

