/*
 * Decompiled with CFR 0.152.
 */
package de.petendi.commons.crypto;

import de.petendi.commons.crypto.connector.CryptoException;
import de.petendi.commons.crypto.connector.SecurityProviderConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;

abstract class BaseAsymmetric {
    protected final String privateKeyEntryString;
    protected final SecurityProviderConnector securityProviderConnector;

    protected BaseAsymmetric(SecurityProviderConnector securityProviderConnector) {
        this(securityProviderConnector, "private-key");
    }

    protected BaseAsymmetric(SecurityProviderConnector securityProviderConnector, String privateKeyEntry) {
        this.privateKeyEntryString = privateKeyEntry;
        this.securityProviderConnector = securityProviderConnector;
    }

    protected final PrivateKey extractPrivateKey(char[] password, InputStream pkcs12Stream) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableEntryException {
        KeyStore inStore = KeyStore.getInstance("PKCS12", this.securityProviderConnector.getProviderName());
        inStore.load(pkcs12Stream, password);
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)inStore.getEntry(this.privateKeyEntryString, new KeyStore.PasswordProtection(password));
        return privateKeyEntry.getPrivateKey();
    }

    protected final PublicKey extractPublicKey(Reader pemReader) throws CryptoException {
        return this.securityProviderConnector.extractPublicKey(pemReader);
    }

    public final boolean containsPrivateKey(char[] password, InputStream pkcs12Stream) {
        try {
            this.extractPrivateKey(password, pkcs12Stream);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean containsPublicKey(Reader pemReader) {
        try {
            this.extractPublicKey(pemReader);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

