/*
 * Decompiled with CFR 0.152.
 */
package de.petendi.commons.crypto;

import de.petendi.commons.crypto.BaseAsymmetric;
import de.petendi.commons.crypto.connector.CryptoException;
import de.petendi.commons.crypto.connector.SecurityProviderConnector;
import java.io.InputStream;
import java.io.Reader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class AsymmetricCrypto
extends BaseAsymmetric {
    public AsymmetricCrypto(SecurityProviderConnector securityProviderConnector) {
        super(securityProviderConnector);
    }

    public AsymmetricCrypto(SecurityProviderConnector securityProviderConnector, String privateKeyEntry) {
        super(securityProviderConnector, privateKeyEntry);
    }

    public byte[] decrypt(byte[] encrypted, char[] password, InputStream pkcs12Stream) {
        try {
            PrivateKey privateKey = this.extractPrivateKey(password, pkcs12Stream);
            return this.decryptInternal(encrypted, privateKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] decrypt(byte[] encrypted, PrivateKey privateKey) {
        try {
            return this.decryptInternal(encrypted, privateKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private byte[] decryptInternal(byte[] encrypted, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher rsa = Cipher.getInstance(this.securityProviderConnector.getCryptoAlgorithm(), this.securityProviderConnector.getProviderName());
        rsa.init(2, privateKey);
        return rsa.doFinal(encrypted);
    }

    public byte[] encrypt(byte[] plain, PublicKey publicKey) {
        try {
            return this.encryptInternal(plain, publicKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] encrypt(byte[] plain, Reader pemReader) {
        try {
            PublicKey publicKey = this.extractPublicKey(pemReader);
            return this.encryptInternal(plain, publicKey);
        }
        catch (CryptoException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private byte[] encryptInternal(byte[] plain, PublicKey publicKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher rsa = Cipher.getInstance(this.securityProviderConnector.getCryptoAlgorithm(), this.securityProviderConnector.getProviderName());
        rsa.init(1, publicKey);
        return rsa.doFinal(plain);
    }
}

