/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.springfox;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import de.pentabyte.springfox.ApiEnum;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147481648)
public class ApiEnumDescriptionPlugin
implements ModelPropertyBuilderPlugin,
ParameterBuilderPlugin {
    private static Logger LOG = LoggerFactory.getLogger(ApiEnumDescriptionPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)delimiter);
    }

    public void apply(ModelPropertyContext context) {
        try {
            ApiModelProperty property;
            Field field;
            AnnotatedField aField;
            Optional beanDef = context.getBeanPropertyDefinition();
            if (beanDef.isPresent() && (aField = ((BeanPropertyDefinition)beanDef.get()).getField()) != null && (field = aField.getAnnotated()) != null && (property = field.getAnnotation(ApiModelProperty.class)) != null) {
                Class<?> clazz = field.getType();
                this.buildDescription(context, property, clazz);
                String dataType = property.dataType();
                if (dataType != null && !"".equals(dataType.trim())) {
                    try {
                        Class<?> clazz2 = Class.forName(dataType);
                        this.buildDescription(context, property, clazz2);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn("Cannot find dataType " + dataType);
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.warn("Cannot process ApiModelProperty. Will throw new RuntimeException now.", t);
            throw new RuntimeException(t);
        }
    }

    private void buildDescription(ModelPropertyContext context, ApiModelProperty property, Class<?> clazz) {
        if (clazz.isEnum()) {
            String description = property.value();
            String markdown = ApiEnumDescriptionPlugin.createMarkdownDescription(clazz);
            if (markdown != null) {
                description = description + "\n" + markdown;
                context.getSpecificationBuilder().description(description);
            }
        }
    }

    public void apply(ParameterContext context) {
        try {
            Optional annotation;
            Class clazz;
            ResolvedType resType;
            ResolvedMethodParameter param = context.resolvedMethodParameter();
            if (param != null && (resType = param.getParameterType()) != null && (clazz = resType.getErasedType()).isEnum() && (annotation = param.findAnnotation(ApiParam.class)).isPresent()) {
                String description = ((ApiParam)annotation.get()).value();
                String markdown = ApiEnumDescriptionPlugin.createMarkdownDescription(clazz);
                if (markdown != null) {
                    description = description + "\n" + markdown;
                    context.requestParameterBuilder().description(description);
                }
            }
        }
        catch (Throwable t) {
            LOG.warn("Cannot process ApiParameter. Will throw new RuntimeException now.", t);
            throw new RuntimeException(t);
        }
    }

    static String createMarkdownDescription(Class<? extends Enum<?>> clazz) {
        Optional<Method> jsonValueMethod = ApiEnumDescriptionPlugin.findJsonValueAnnotatedMethod(clazz);
        ArrayList<String> lines = new ArrayList<String>();
        boolean foundAny = false;
        for (Enum<?> enumVal : clazz.getEnumConstants()) {
            String desc = ApiEnumDescriptionPlugin.readApiDescription(enumVal);
            if (desc != null) {
                foundAny = true;
            }
            String enumName = jsonValueMethod.map(ApiEnumDescriptionPlugin.evaluateJsonValue(enumVal)).orElse(enumVal.name());
            String line = "* " + enumName + ": " + (desc == null ? "_@ApiEnum annotation not available_" : desc);
            lines.add(line);
        }
        if (foundAny) {
            return String.join((CharSequence)"\n", lines);
        }
        return null;
    }

    static String readApiDescription(Enum<?> e) {
        try {
            ApiEnum annotation = e.getClass().getField(e.name()).getAnnotation(ApiEnum.class);
            if (annotation != null) {
                return annotation.value();
            }
        }
        catch (NoSuchFieldException e1) {
            throw new RuntimeException("impossible?", e1);
        }
        catch (SecurityException e1) {
            throw new RuntimeException("could not read annotation", e1);
        }
        return null;
    }

    private static Optional<Method> findJsonValueAnnotatedMethod(Class<? extends Enum<?>> clazz) {
        for (Method each : clazz.getMethods()) {
            JsonValue jsonValue = (JsonValue)AnnotationUtils.findAnnotation((Method)each, JsonValue.class);
            if (jsonValue == null || !jsonValue.value()) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private static Function<Method, String> evaluateJsonValue(final Object enumConstant) {
        return new Function<Method, String>(){

            @Override
            public String apply(Method input) {
                try {
                    return input.invoke(enumConstant, new Object[0]).toString();
                }
                catch (Exception ignored) {
                    return "";
                }
            }
        };
    }
}

