/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.springfox;

import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.base.Optional;
import de.pentabyte.springfox.ApiEnum;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147481648)
public class ApiEnumDescriptionPlugin
implements ModelPropertyBuilderPlugin {
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)delimiter);
    }

    public void apply(ModelPropertyContext context) {
        ApiModelProperty property;
        Class<?> clazz;
        Field field;
        AnnotatedField aField;
        Optional beanDef = context.getBeanPropertyDefinition();
        if (beanDef.isPresent() && (aField = ((BeanPropertyDefinition)beanDef.get()).getField()) != null && (field = aField.getAnnotated()) != null && (clazz = field.getType()).isEnum() && (property = field.getAnnotation(ApiModelProperty.class)) != null) {
            String description = property.value();
            String markdown = ApiEnumDescriptionPlugin.createMarkdownDescription(clazz);
            if (markdown != null) {
                description = description + "\n" + markdown;
                context.getBuilder().description(description);
            }
        }
    }

    static String createMarkdownDescription(Class<? extends Enum<?>> clazz) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean foundAny = false;
        for (Enum<?> enumVal : clazz.getEnumConstants()) {
            String desc = ApiEnumDescriptionPlugin.readApiDescription(enumVal);
            if (desc != null) {
                foundAny = true;
            }
            String line = "* " + enumVal.name() + ": " + (desc == null ? "_@ApiEnum annotation not available_" : desc);
            lines.add(line);
        }
        if (foundAny) {
            return StringUtils.join(lines, (String)"\n");
        }
        return null;
    }

    static String readApiDescription(Enum<?> e) {
        try {
            ApiEnum annotation = e.getClass().getField(e.name()).getAnnotation(ApiEnum.class);
            if (annotation != null) {
                return annotation.value();
            }
        }
        catch (NoSuchFieldException e1) {
            throw new RuntimeException("impossible?", e1);
        }
        catch (SecurityException e1) {
            throw new RuntimeException("could not read annotation", e1);
        }
        return null;
    }
}

