/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.imageio.icns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum OSType {
    icp4(16, 1),
    icp5(32, 1),
    icp6(64, 1),
    ic07(128, 1),
    ic08(256, 1),
    ic09(512, 1),
    ic10(1024, 2),
    ic11(32, 2),
    ic12(64, 2),
    ic13(256, 2),
    ic14(512, 2);

    private final int pixelSize;
    private final int devicePixelRatio;

    private OSType(int pixelSize, int devicePixelRatio) {
        this.pixelSize = pixelSize;
        this.devicePixelRatio = devicePixelRatio;
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    public int getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public String toString() {
        return this.name() + ": " + this.pixelSize + "x" + this.pixelSize + (this.devicePixelRatio != 1 ? "@" + this.devicePixelRatio + "x" : "");
    }

    public static OSType valueOf(int pixelSize, int devicePixelRatio) {
        for (OSType type : OSType.values()) {
            if (type.pixelSize != pixelSize || type.devicePixelRatio != devicePixelRatio) continue;
            return type;
        }
        String types = Arrays.stream(OSType.values()).map(e -> e.toString()).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("No type found for pixel size " + pixelSize + " and device pixel ratio " + devicePixelRatio + ". Available types: " + types);
    }

    public static OSType valueOf(int pixelSize) {
        ArrayList<OSType> candidates = new ArrayList<OSType>();
        for (OSType type : OSType.values()) {
            if (type.pixelSize != pixelSize) continue;
            candidates.add(type);
        }
        candidates.sort((t1, t2) -> {
            int primary = t2.pixelSize - t1.pixelSize;
            if (primary == 0) {
                return t2.devicePixelRatio - t1.devicePixelRatio;
            }
            return primary;
        });
        if (candidates.size() == 0) {
            String sizes = Arrays.stream(OSType.values()).map(e -> String.valueOf(e.pixelSize)).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("No type found for pixel size " + pixelSize + ". Available sizes: " + sizes);
        }
        return (OSType)((Object)candidates.get(0));
    }
}

