/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.imageio.icns;

import de.pentabyte.imageio.icns.ICNSWriteParam;
import de.pentabyte.imageio.icns.OSType;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class ICNSImageWriter
extends ImageWriter {
    protected ICNSImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        ICNSWriteParam wparam = new ICNSWriteParam();
        wparam.setDevicePixelRatio(2);
        return wparam;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int devicePixelRatio;
        ImageOutputStream ios = (ImageOutputStream)this.getOutput();
        RenderedImage renderedImage = image.getRenderedImage();
        if (renderedImage.getWidth() != renderedImage.getHeight()) {
            throw new RuntimeException("image size must be square.");
        }
        if (param != null) {
            ICNSWriteParam writeParam = (ICNSWriteParam)param;
            devicePixelRatio = writeParam.getDevicePixelRatio();
        } else {
            devicePixelRatio = 2;
        }
        OSType type = OSType.valueOf(renderedImage.getWidth(), devicePixelRatio);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("png");
        if (!writers.hasNext()) {
            throw new RuntimeException(this.getClass().getSimpleName() + " requires PNG image writer.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write(renderedImage, "PNG", baos);
        ios.writeBytes("icns");
        ios.writeInt(baos.size() + 12);
        ios.writeBytes(type.name());
        ios.writeInt(baos.size() + 4);
        ios.write(baos.toByteArray());
    }
}

