/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.googlemaps;

import de.pentabyte.googlemaps.Color;
import de.pentabyte.googlemaps.LatLon;
import de.pentabyte.googlemaps.PolylineEncoder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StaticPath
implements Serializable {
    private static int EARTH_RADIUS = 6371000;
    private static final long serialVersionUID = -1938620346181841310L;
    private String color;
    private String fillColor;
    private Integer weight;
    private final List<LatLon> coords;
    private final String polyline;

    public StaticPath(List<LatLon> coords) {
        this.coords = coords;
        this.polyline = null;
    }

    public StaticPath(String polyline) {
        this.coords = null;
        this.polyline = polyline;
    }

    public List<LatLon> getCoords() {
        return this.coords;
    }

    private static List<LatLon> reduce(List<LatLon> list) {
        ArrayList<LatLon> less = new ArrayList<LatLon>();
        for (int i = 0; i < list.size(); ++i) {
            if (i % 2 != 0) continue;
            less.add(list.get(i));
        }
        if ((list.size() - 1) % 2 != 0) {
            less.add(list.get(list.size() - 1));
        }
        return less;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color.name();
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor.name();
    }

    public void setHexFillColor(String hexFillColor) {
        this.fillColor = "0x" + hexFillColor;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setHexColor(String hexColor) {
        this.color = "0x" + hexColor;
    }

    protected String formatFor(double minDistanceMeters, int maxPoints) {
        ArrayList<String> defs = new ArrayList<String>();
        if (this.color != null) {
            defs.add("color:" + this.color);
        }
        if (this.fillColor != null) {
            defs.add("fillcolor:" + this.fillColor);
        }
        if (this.weight != null) {
            defs.add("weight:" + this.weight);
        }
        if (this.coords != null) {
            List<LatLon> reduced = new ArrayList<LatLon>();
            LatLon lastCoord = null;
            for (LatLon coord : this.coords) {
                if (lastCoord != null && !(StaticPath.distanceApproximate(lastCoord, coord) > minDistanceMeters)) continue;
                reduced.add(coord);
                lastCoord = coord;
            }
            while (reduced.size() > maxPoints) {
                reduced = StaticPath.reduce(reduced);
            }
            PolylineEncoder encoder = new PolylineEncoder();
            for (LatLon coord : reduced) {
                encoder.add(coord.getLatitude(), coord.getLongitude());
            }
            defs.add("enc:" + encoder.toString());
        }
        if (this.polyline != null) {
            defs.add("enc:" + this.polyline);
        }
        return StringUtils.join(defs, (char)'|');
    }

    protected static double distanceAuto(LatLon c1, LatLon c2) {
        return StaticPath.distanceAuto(c1.getLatitude(), c1.getLongitude(), c2.getLatitude(), c2.getLongitude());
    }

    protected static double distanceAuto(double lat1, double lon1, double lat2, double lon2) {
        double dLat = Math.abs(lat1 - lat2);
        if (dLat > 4.0) {
            return StaticPath.distance(lat1, lon1, lat2, lon2);
        }
        double dLon = Math.abs(lon1 - lon2);
        if (dLon > 4.0) {
            return StaticPath.distance(lat1, lon1, lat2, lon2);
        }
        return StaticPath.distanceApproximate(lat1, lon1, lat2, lon2);
    }

    protected static double distance(double lat1, double lon1, double lat2, double lon2) {
        double dLat = Math.toRadians(lat2 - lat1);
        double dLng = Math.toRadians(lon2 - lon1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return (double)EARTH_RADIUS * c;
    }

    protected static double distanceApproximate(LatLon coord1, LatLon coord2) {
        return StaticPath.distanceApproximate(coord1.getLatitude(), coord1.getLongitude(), coord2.getLatitude(), coord2.getLongitude());
    }

    protected static double distanceApproximate(double lat1, double lon1, double lat2, double lon2) {
        if (lon1 < 0.0) {
            lon1 += 360.0;
        }
        if (lon2 < 0.0) {
            lon2 += 360.0;
        }
        lat1 = Math.toRadians(lat1);
        lon1 = Math.toRadians(lon1);
        lat2 = Math.toRadians(lat2);
        lon2 = Math.toRadians(lon2);
        double x = (lon2 - lon1) * Math.cos((lat1 + lat2) / 2.0);
        double y = lat2 - lat1;
        return Math.sqrt(x * x + y * y) * (double)EARTH_RADIUS;
    }
}

