package de.pco.imageio;

/*-
 * #%L
 * pco-imageio
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;

import de.pco.common.AbstractImageData;
import de.pco.common.ImageData;
import de.pco.common.UShortArray;

/**
 * Support class for the tests.
 * @author PCO
 *
 */
public class TestUtils {
    /**
     * Returns the list of the images as it will be returned by Camera.getTestImages()
     * @return
     * @throws IOException
     */
    public static List<AbstractImageData> getTestImages() throws IOException 
    {
        BufferedImage bi3 = ImageIO.read(TestUtils.class.getResource("/test2.tif"));
        int width = bi3.getWidth();
        int height = bi3.getHeight();
        BufferedImage bi4 = ImageIO.read(TestUtils.class.getResource("/test3.tif"));
        BufferedImage bi5 = ImageIO.read(TestUtils.class.getResource("/test4.tif"));
        BufferedImage bi6 = ImageIO.read(TestUtils.class.getResource("/test6.tif"));
        short[] data3 = ((DataBufferUShort)(bi3.getRaster().getDataBuffer())).getData();
        short[] data4 = ((DataBufferUShort)(bi4.getRaster().getDataBuffer())).getData();
        short[] data5 = ((DataBufferUShort)(bi5.getRaster().getDataBuffer())).getData();
        short[] data6 = ((DataBufferUShort)(bi6.getRaster().getDataBuffer())).getData();
        AbstractImageData aid3 = new ImageData(new UShortArray(data3), width, height,null);
        AbstractImageData aid4 = new ImageData(new UShortArray(data4), width, height,null);
        AbstractImageData aid5 = new ImageData(new UShortArray(data5), width, height,null);
        AbstractImageData aid6 = new ImageData(new UShortArray(data6), width, height,null);
        List<AbstractImageData> aidList = new ArrayList<AbstractImageData>();
        aidList.add(aid3);
        aidList.add(aid4);
        aidList.add(aid5);
        aidList.add(aid6);
        //we get this state of list immediately by camera.getImages or recorder.loadMultiFile
        return aidList;
    }

}
