package de.pco.imageio;

/*-
 * #%L
 * pco-imageio
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;

import org.junit.jupiter.api.Test;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import de.pco.sdk.BildStruct;

/**
 * Tests the PcoIIOMetadata.
 * @author PCO
 *
 */
public class PcoIIOMetadataTest 
{
    private static StringBuilder s;
    
    /**
     * Loads B16 metadata, gets them as the XML and loads to other metadata class from this XML,
     * then compares the MetadataBena (Bild-Struct in C)
     * @throws IOException
     */
    @Test
    void mergeNativeTreeTest() throws IOException
    {
        B16ImageReader reader = new B16ImageReader();
        URL resource = getClass().getResource("/test.b16");
        ImageInputStream iis = ImageIO.createImageInputStream(resource.openStream());
        reader.setInput(iis);
        BufferedImage image = reader.read(0);
        PcoIIOMetadata metadata = (PcoIIOMetadata)reader.getImageMetadata(0);
        PcoIIOMetadata metadata2 = new PcoIIOMetadata(new BildStruct());
        
        IIOMetadataNode node = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
        displayMetadata(node);
        String s1 = s.toString();
        BildStruct bean1 = metadata.getBildStruct();
        
        metadata2.mergeTree(metadata2.getNativeMetadataFormatName(), node);
        Node node2 = metadata2.getAsTree(metadata2.getNativeMetadataFormatName());
        BildStruct bean2 = metadata2.getBildStruct();
        String s2 = s.toString();
        
        assertEquals(s2, s1);
        assertEquals(bean2, bean1);
        
        // the same on the color picture
        reader = new B16ImageReader();
        resource = getClass().getResource("/image.b16");
        iis = ImageIO.createImageInputStream(resource.openStream());
        reader.setInput(iis);
        image = reader.read(0);
        metadata = (PcoIIOMetadata)reader.getImageMetadata(0);
        metadata2 = new PcoIIOMetadata(new BildStruct());
        
        node = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
        displayMetadata(node);
        s1 = s.toString();
        bean1 = metadata.getBildStruct();
        
        metadata2.mergeTree(metadata2.getNativeMetadataFormatName(), node);
        node2 = metadata2.getAsTree(metadata2.getNativeMetadataFormatName());
        bean2 = metadata2.getBildStruct();
        s2 = s.toString();
        
        assertEquals(s2, s1);
        assertEquals(bean2, bean1);
//        
    }
    
    /**
     * Tests whether the standard XML output is the same in the original class and in the
     * class that was loaded from from this XML
     * @throws IOException
     */
    @Test
    void mergeStandardTreeTest() throws IOException
    {
        B16ImageReader reader = new B16ImageReader();
        URL resource = getClass().getResource("/test.b16");
        reader.setInput(ImageIO.createImageInputStream(resource.openStream()));
        BufferedImage image = reader.read(0);
        PcoIIOMetadata metadata = (PcoIIOMetadata)reader.getImageMetadata(0);
        PcoIIOMetadata metadata2 = new PcoIIOMetadata(new BildStruct());
        
        IIOMetadataNode node = (IIOMetadataNode)metadata.getAsTree("javax_imageio_1.0");
        displayMetadata(node);
        String s1 = s.toString();
        
        metadata2.mergeTree("javax_imageio_1.0", node);
        Node node2 = metadata2.getAsTree("javax_imageio_1.0");
        String s2 = s.toString();
        
        assertEquals(s2, s1);
        //MetadataBean bean = metadata.getMetadataBean();
//        
    }
    
    private static void displayMetadata(Node root) {
        s = new StringBuilder();
        displayMetadata(root, 0);
    }

    private static void indent(int level) {
        for (int i = 0; i < level; i++) {
            s.append("  ");
        }
    } 

    private static void displayMetadata(Node node, int level) {
        indent(level); // emit open tag
        s.append("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) { // print attribute values
                int length = map.getLength();
                for (int i = 0; i < length; i++) {
                        Node attr = map.item(i);
                        s.append(" " + attr.getNodeName() +
                                         "=\"" + attr.getNodeValue() + "\"");
                }
        }

        Node child = node.getFirstChild();
        if (child != null) {
                s.append(">\n"); // close current tag
                while (child != null) { // emit child tags recursively
                        displayMetadata(child, level + 1);
                        child = child.getNextSibling();
                }
                indent(level); // emit close tag
                s.append("</" + node.getNodeName() + ">\n");
        } else {
                s.append("/>\n");
        }
    }
}
