package de.pco.imageio;

/*-
 * #%L
 * pco-imageio
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;

import org.junit.jupiter.api.Test;

/**
 * Tests the B16ImageReader.
 * @author PCO
 *
 */
public class B16ImageReaderTest 
{	
    /**
     * Reads a B16 file to BufferedImage, and saves it in the temp PNG file
     * C:\Users\{user}\AppData\Local\Temp\pco-test-{...}.png
     * to be checked.
     * @throws IOException
     */
	@Test
	void testRead() throws IOException 
	{
		URL resource = getClass().getResource("/test.b16");
		BufferedImage bi = ImageIO.read(resource);
		assertNotNull(bi);
		assertEquals(DataBuffer.TYPE_USHORT, bi.getSampleModel().getDataType());
        assertEquals(PixelInterleavedSampleModel.class, bi.getSampleModel().getClass());
     
        File file = File.createTempFile("pco-testRead-", ".png");
		ImageIO.write(bi, "png", file);		
		//visually check image C:\Users\{user}\AppData\Local\Temp\pco-test-{...}.png
	}
}
