/*
 * Decompiled with CFR 0.152.
 */
package de.pco.imageio;

import de.pco.common.AbstractImageData;
import de.pco.imageio.RawImageInputStream;
import de.pco.imageio.RawImageReader;
import de.pco.imageio.TestUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RawImageReaderTest {
    @Test
    void testReadCompressed() throws IOException {
        URL resource = this.getClass().getResource("/test.bmp");
        BufferedImage bi = ImageIO.read(resource);
        byte[] data = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        RawImageInputStream riis = new RawImageInputStream(ImageIO.createImageInputStream(bais), bi.getWidth(), bi.getHeight(), true);
        RawImageReader reader = new RawImageReader();
        reader.setInput((Object)riis);
        BufferedImage bi2 = reader.read(0);
        Assertions.assertNotNull((Object)bi2);
        Assertions.assertEquals((int)0, (int)bi2.getSampleModel().getDataType());
        Assertions.assertEquals(PixelInterleavedSampleModel.class, bi2.getSampleModel().getClass());
        File file = File.createTempFile("pco-testReadCompressed-", ".png");
        ImageIO.write((RenderedImage)bi, "png", file);
    }

    @Test
    void testReadSecondPass() throws IOException {
        URL resource = this.getClass().getResource("/test.bmp");
        BufferedImage bi = ImageIO.read(resource);
        byte[] data = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        RawImageInputStream riis = new RawImageInputStream(ImageIO.createImageInputStream(bais), bi.getWidth(), bi.getHeight(), true);
        RawImageReader reader = new RawImageReader();
        reader.setInput((Object)riis);
        BufferedImage bi2 = reader.read(0);
        BufferedImage bi3 = reader.read(0);
        Assertions.assertNotNull((Object)bi3);
        Assertions.assertEquals((int)0, (int)bi3.getSampleModel().getDataType());
        Assertions.assertEquals(PixelInterleavedSampleModel.class, bi3.getSampleModel().getClass());
    }

    @Test
    void testReaderOnMultiStream() throws IOException {
        List<AbstractImageData> aidList = TestUtils.getTestImages();
        RawImageInputStream riis = new RawImageInputStream(aidList);
        RawImageReader reader = new RawImageReader();
        reader.setInput((Object)riis);
        BufferedImage bi1 = reader.read(0);
        BufferedImage bi2 = reader.read(1);
        BufferedImage bi3 = reader.read(2);
        File file = File.createTempFile("pco-testReaderOnMultiStream-", ".png");
        ImageIO.write((RenderedImage)bi1, "png", file);
        file = File.createTempFile("pco-testReaderOnMultiStream-", ".png");
        ImageIO.write((RenderedImage)bi2, "png", file);
        file = File.createTempFile("pco-testReaderOnMultiStream-", ".png");
        ImageIO.write((RenderedImage)bi3, "png", file);
        URL resource = this.getClass().getResource("/test.bmp");
        BufferedImage bi = ImageIO.read(resource);
        byte[] data = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        RawImageInputStream riis2 = new RawImageInputStream(ImageIO.createImageInputStream(bais), bi.getWidth(), bi.getHeight(), true);
        reader.setInput((Object)riis2);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> reader.read(1));
        BufferedImage bi4 = reader.read(0);
        file = File.createTempFile("pco-testReaderOnMultiStream-", ".png");
        ImageIO.write((RenderedImage)bi4, "png", file);
    }
}

