/*
 * Decompiled with CFR 0.152.
 */
package de.pco.imageio;

import de.pco.common.AbstractImageData;
import de.pco.common.ImageDataCompressed;
import de.pco.common.UByteArray;
import de.pco.imageio.RawImageInputStream;
import de.pco.imageio.TestUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RawImageInputStreamTest {
    RawImageInputStreamTest() {
    }

    @Test
    void testSingeImageInStream() throws IOException {
        URL resource = this.getClass().getResource("/test.bmp");
        BufferedImage bi = ImageIO.read(resource);
        byte[] data = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
        UByteArray ubb = new UByteArray(data);
        ImageDataCompressed idc = new ImageDataCompressed(ubb, bi.getWidth(), bi.getHeight());
        RawImageInputStream riis = new RawImageInputStream((AbstractImageData)idc);
        Assertions.assertDoesNotThrow(() -> riis.openSubstreamOnImage(0));
        Assertions.assertDoesNotThrow(() -> riis.readInt());
        riis.close();
        Assertions.assertThrows(IllegalStateException.class, () -> riis.readInt());
    }

    @Test
    void testMultiImageInStream() throws IOException {
        List<AbstractImageData> aidList = TestUtils.getTestImages();
        RawImageInputStream riis = new RawImageInputStream(aidList);
        Assertions.assertEquals((int)4, (int)riis.getNumImages());
        Assertions.assertNull((Object)riis.getMetadata(3));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> riis.getMetadata(4));
        Assertions.assertThrows(IllegalStateException.class, () -> riis.readInt());
        riis.openSubstreamOnImage(3);
        Assertions.assertDoesNotThrow(() -> riis.readInt());
    }
}

