/*
 * Decompiled with CFR 0.152.
 */
package de.pco.imageio;

import de.pco.common.MetadataBean;
import de.pco.imageio.B16ImageReader;
import de.pco.imageio.PcoIIOMetadata;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PcoIIOMetadataTest {
    private static StringBuilder s;

    @Test
    void mergeNativeTreeTest() throws IOException {
        B16ImageReader reader = new B16ImageReader();
        URL resource = this.getClass().getResource("/test.b16");
        ImageInputStream iis = ImageIO.createImageInputStream(resource.openStream());
        reader.setInput((Object)iis);
        BufferedImage image = reader.read(0);
        PcoIIOMetadata metadata = (PcoIIOMetadata)reader.getImageMetadata(0);
        PcoIIOMetadata metadata2 = new PcoIIOMetadata(new MetadataBean());
        IIOMetadataNode node = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
        PcoIIOMetadataTest.displayMetadata(node);
        String s1 = s.toString();
        MetadataBean bean1 = metadata.getMetadataBean();
        metadata2.mergeTree(metadata2.getNativeMetadataFormatName(), (Node)node);
        Node node2 = metadata2.getAsTree(metadata2.getNativeMetadataFormatName());
        MetadataBean bean2 = metadata2.getMetadataBean();
        String s2 = s.toString();
        Assertions.assertEquals((Object)s2, (Object)s1);
        Assertions.assertEquals((Object)bean2, (Object)bean1);
        reader = new B16ImageReader();
        resource = this.getClass().getResource("/image.b16");
        iis = ImageIO.createImageInputStream(resource.openStream());
        reader.setInput((Object)iis);
        image = reader.read(0);
        metadata = (PcoIIOMetadata)reader.getImageMetadata(0);
        metadata2 = new PcoIIOMetadata(new MetadataBean());
        node = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
        PcoIIOMetadataTest.displayMetadata(node);
        s1 = s.toString();
        bean1 = metadata.getMetadataBean();
        metadata2.mergeTree(metadata2.getNativeMetadataFormatName(), (Node)node);
        node2 = metadata2.getAsTree(metadata2.getNativeMetadataFormatName());
        bean2 = metadata2.getMetadataBean();
        s2 = s.toString();
        Assertions.assertEquals((Object)s2, (Object)s1);
        Assertions.assertEquals((Object)bean2, (Object)bean1);
    }

    @Test
    void mergeStandardTreeTest() throws IOException {
        B16ImageReader reader = new B16ImageReader();
        URL resource = this.getClass().getResource("/test.b16");
        reader.setInput((Object)ImageIO.createImageInputStream(resource.openStream()));
        BufferedImage image = reader.read(0);
        PcoIIOMetadata metadata = (PcoIIOMetadata)reader.getImageMetadata(0);
        PcoIIOMetadata metadata2 = new PcoIIOMetadata(new MetadataBean());
        IIOMetadataNode node = (IIOMetadataNode)metadata.getAsTree("javax_imageio_1.0");
        PcoIIOMetadataTest.displayMetadata(node);
        String s1 = s.toString();
        metadata2.mergeTree("javax_imageio_1.0", (Node)node);
        Node node2 = metadata2.getAsTree("javax_imageio_1.0");
        String s2 = s.toString();
        Assertions.assertEquals((Object)s2, (Object)s1);
    }

    private static void displayMetadata(Node root) {
        s = new StringBuilder();
        PcoIIOMetadataTest.displayMetadata(root, 0);
    }

    private static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            s.append("  ");
        }
    }

    private static void displayMetadata(Node node, int level) {
        Node child;
        PcoIIOMetadataTest.indent(level);
        s.append("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                s.append(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            s.append(">\n");
            while (child != null) {
                PcoIIOMetadataTest.displayMetadata(child, level + 1);
                child = child.getNextSibling();
            }
            PcoIIOMetadataTest.indent(level);
            s.append("</" + node.getNodeName() + ">\n");
        } else {
            s.append("/>\n");
        }
    }
}

