/*
 * Decompiled with CFR 0.152.
 */
package de.pco.imageio;

import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageMetadata;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReader;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReaderSpi;
import de.pco.common.MetadataBean;
import de.pco.common.enums.CameraSyncMode;
import de.pco.common.enums.ImageType;
import de.pco.common.enums.SyncStatus;
import de.pco.common.enums.TriggerMode;
import de.pco.imageio.B16ImageReader;
import de.pco.imageio.B16ImageWriter;
import de.pco.imageio.PcoIIOMetadata;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class B16ImageWriterTest {
    @Test
    void testWrite() throws IOException {
        URL resource = this.getClass().getResource("/test.b16");
        B16ImageReader reader = new B16ImageReader();
        ImageInputStream iis = ImageIO.createImageInputStream(resource.openConnection().getInputStream());
        reader.setInput((Object)iis);
        IIOImage image = reader.readAll(0, null);
        PcoIIOMetadata originalMetadata = (PcoIIOMetadata)image.getMetadata();
        MetadataBean originalMbean = originalMetadata.getMetadataBean();
        Assertions.assertNotNull((Object)image);
        B16ImageWriter writer = new B16ImageWriter();
        File file = File.createTempFile("pco-testWrite-", ".b16");
        writer.setOutput((Object)ImageIO.createImageOutputStream(file));
        writer.write(image);
        reader.setInput((Object)ImageIO.createImageInputStream(file));
        image = reader.readAll(0, null);
        PcoIIOMetadata metadata = (PcoIIOMetadata)image.getMetadata();
        MetadataBean mBean = metadata.getMetadataBean();
        Assertions.assertEquals((Object)mBean, (Object)originalMbean);
    }

    @Test
    void testConvertImageMetadata() throws IOException {
        TIFFImageReaderSpi spi = new TIFFImageReaderSpi();
        URL resource = this.getClass().getResource("/test5.tif");
        ImageInputStream iis = ImageIO.createImageInputStream(resource.openConnection().getInputStream());
        TIFFImageReader reader = (TIFFImageReader)spi.createReaderInstance();
        reader.setInput((Object)iis);
        BufferedImage bi = reader.read(0, reader.getDefaultReadParam());
        IIOMetadata meta = reader.getImageMetadata(0);
        TIFFImageMetadata tm = (TIFFImageMetadata)meta;
        B16ImageWriter writer = new B16ImageWriter();
        ImageTypeSpecifier imageType = (ImageTypeSpecifier)reader.getImageTypes(0).next();
        PcoIIOMetadata convertedMetadata = (PcoIIOMetadata)writer.convertImageMetadata((IIOMetadata)tm, imageType, null);
        MetadataBean mBean = convertedMetadata.getMetadataBean();
        Assertions.assertEquals((int)2018, (int)mBean.time.year);
        Assertions.assertEquals((int)10, (int)mBean.time.month);
        Assertions.assertEquals((int)2, (int)mBean.time.dayOfWeek);
        Assertions.assertEquals((int)23, (int)mBean.time.day);
        Assertions.assertEquals((int)13, (int)mBean.time.hour);
        Assertions.assertEquals((int)5, (int)mBean.time.minute);
        Assertions.assertEquals((int)0, (int)mBean.time.second);
        Assertions.assertEquals((int)799, (int)mBean.time.milliseconds);
        Assertions.assertEquals((int)0, (int)mBean.ticks);
        Assertions.assertEquals((int)4096, (int)mBean.xRes);
        Assertions.assertEquals((int)2160, (int)mBean.yRes);
        Assertions.assertEquals((int)1, (int)mBean.binningX);
        Assertions.assertEquals((int)1, (int)mBean.binningY);
        Assertions.assertEquals((Object)TriggerMode.AUTOTRIGGER, (Object)mBean.triggerMode);
        Assertions.assertEquals((Object)CameraSyncMode.STANDALONE, (Object)mBean.cameraSyncMode);
        Assertions.assertEquals((long)55000000L, (long)mBean.sensorReadoutFrequency);
        Assertions.assertEquals((long)12900335L, (long)mBean.cameraSerialNo);
        Assertions.assertEquals((Object)SyncStatus.OFF, (Object)mBean.syncStatus);
        Assertions.assertEquals((Object)ImageType.UNDEFINED, (Object)mBean.imageType);
    }
}

