/*
 * Decompiled with CFR 0.152.
 */
package de.pco.example;

import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageMetadata;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReaderSpi;
import de.pco.camera.Camera;
import de.pco.camera.ConfigurationParameter;
import de.pco.camera.ExtendedRecorderType;
import de.pco.common.ImageData;
import de.pco.common.exceptions.PcoException;
import de.pco.example.MetadataTableEditor;
import de.pco.example.MetadataTableModel;
import de.pco.example.MetadataTableRenderer;
import de.pco.example.PaintPanel;
import de.pco.imageio.B16ImageReader;
import de.pco.imageio.B16ImageReaderSpi;
import de.pco.imageio.B16ImageWriter;
import de.pco.imageio.PcoIIOMetadata;
import de.pco.imageio.RawImageInputStream;
import de.pco.imageio.RawImageReader;
import de.pco.sdk.BildStruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GuiExample
extends JFrame {
    private static StringBuilder sb = null;
    private static final String APPLICATION_TITLE = "PCO.java Example Application";
    private static final int INITIAL_REQUIRED_IMAGES = 10;
    private JMenuBar menuMB = null;
    private JMenuItem showMetadataMI = null;
    private PaintPanel paintP = null;
    private JTextField numImagesTF = null;
    private JTextField curImageTF = null;
    private JButton recordB = null;
    private JButton cameraB = null;
    private JButton leftB = null;
    private JButton rightB = null;
    private PcoIIOMetadata metadata = null;
    private MetadataTableModel metadataTM = null;
    private MetadataTableEditor metadataTE = null;
    private IIOImage imageContainer = null;
    private JMenuItem saveMI = null;
    private JLabel statusL = null;
    private int curImgIndex = -1;
    private int requiredImages = -1;
    private JFileChooser openFC = null;
    private JFileChooser saveFC = null;
    private Camera camera = null;
    private RawImageReader reader = null;
    private List<ImageData> images = null;

    private GuiExample() {
        final GuiExample self = this;
        this.setTitle(APPLICATION_TITLE);
        this.setSize(new Dimension(800, 500));
        this.setDefaultCloseOperation(2);
        Dimension minimumSize = new Dimension(500, 50);
        JPanel mainP = new JPanel(new BorderLayout());
        JPanel buttonsP = new JPanel();
        buttonsP.setLayout(new BoxLayout(buttonsP, 3));
        buttonsP.setBorder(BorderFactory.createBevelBorder(1));
        this.cameraB = new JButton("CS");
        this.cameraB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    self.camera = new Camera();
                    self.numImagesTF.setText("10");
                    self.requiredImages = 10;
                    self.numImagesTF.setEnabled(true);
                    self.cameraB.setEnabled(false);
                }
                catch (PcoException e1) {
                    JOptionPane.showMessageDialog(self, e1.getMessage(), "Error by opening the camera", 0, null);
                    return;
                }
                self.recordB.setEnabled(true);
            }
        });
        this.cameraB.setAlignmentX(0.0f);
        this.cameraB.setEnabled(true);
        buttonsP.add(this.cameraB);
        JPanel numImagesP = new JPanel();
        numImagesP.setMaximumSize(new Dimension(500, 100));
        numImagesP.setLayout(new BoxLayout(numImagesP, 2));
        numImagesP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        numImagesP.setAlignmentX(0.0f);
        JLabel numImagesL = new JLabel("Number of images:");
        this.numImagesTF = new JTextField(5);
        this.numImagesTF.setEnabled(false);
        this.numImagesTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.recordB.doClick();
            }
        });
        numImagesP.add(numImagesL);
        numImagesP.add(Box.createRigidArea(new Dimension(20, 0)));
        numImagesP.add(this.numImagesTF);
        buttonsP.add(numImagesP);
        this.recordB = new JButton("Record");
        this.recordB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int numImages = -1;
                try {
                    numImages = Integer.valueOf(self.numImagesTF.getText());
                }
                catch (NumberFormatException e1) {
                    JOptionPane.showMessageDialog(self, e1.getMessage(), "Error by number format", 0, null);
                    return;
                }
                try {
                    self.requiredImages = numImages;
                    GuiExample.this.camera.setConfiguration(ConfigurationParameter.EXPOSURE_TIME, (Object)0.01);
                    GuiExample.this.camera.record((long)numImages, ExtendedRecorderType.SEQUENCE);
                    self.reader = new RawImageReader();
                    self.curImageTF.setEnabled(true);
                    self.saveMI.setEnabled(true);
                    GuiExample.this.images = GuiExample.this.camera.getImages();
                    RawImageInputStream riis = new RawImageInputStream(GuiExample.this.images);
                    GuiExample.this.reader.setInput((Object)riis);
                    self.switchImage(0);
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(self, e1.getMessage(), "Error by setting the recorder", 0, null);
                    return;
                }
            }
        });
        this.recordB.setEnabled(false);
        this.recordB.setAlignmentX(0.0f);
        this.recordB.setAlignmentX(0.0f);
        buttonsP.add(this.recordB);
        JPanel curImageP = new JPanel();
        curImageP.setMaximumSize(new Dimension(500, 100));
        curImageP.setLayout(new BoxLayout(curImageP, 2));
        curImageP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        curImageP.setAlignmentX(0.0f);
        JLabel curImagesL = new JLabel("Current image:");
        this.curImageTF = new JTextField(5);
        this.curImageTF.setEnabled(false);
        this.curImageTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int num = -1;
                try {
                    num = Integer.valueOf(GuiExample.this.curImageTF.getText());
                    self.switchImage(num);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(self, ex.getMessage(), "Error by number format", 0);
                    return;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(self, ex.getMessage(), "Error by switching the image", 0, null);
                    return;
                }
            }
        });
        curImageP.add(curImagesL);
        curImageP.add(Box.createRigidArea(new Dimension(20, 0)));
        curImageP.add(this.curImageTF);
        buttonsP.add(curImageP);
        JPanel leftRightP = new JPanel();
        this.leftB = new JButton("<--");
        this.leftB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiExample.this.switchImage(GuiExample.this.curImgIndex - 1);
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(self, e1.getMessage(), "Error by switching the image", 0, null);
                    return;
                }
            }
        });
        this.leftB.setEnabled(false);
        this.rightB = new JButton("-->");
        this.rightB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiExample.this.switchImage(GuiExample.this.curImgIndex + 1);
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(self, e1.getMessage(), "Error by switching the image", 0, null);
                    return;
                }
            }
        });
        this.rightB.setEnabled(false);
        leftRightP.add(this.leftB);
        leftRightP.add(this.rightB);
        leftRightP.setAlignmentX(0.0f);
        buttonsP.add(leftRightP);
        buttonsP.add(Box.createVerticalGlue());
        this.paintP = new PaintPanel();
        mainP.add((Component)buttonsP, "Before");
        mainP.add((Component)this.paintP, "Center");
        this.metadataTM = new MetadataTableModel();
        JTable tableT = new JTable(this.metadataTM);
        this.metadataTE = new MetadataTableEditor();
        tableT.setDefaultEditor(Object.class, this.metadataTE);
        tableT.setDefaultRenderer(Object.class, new MetadataTableRenderer());
        JScrollPane metadataSP = new JScrollPane(tableT);
        JSplitPane splitP = new JSplitPane(1, false, mainP, metadataSP);
        splitP.setDividerLocation(0.9);
        this.add(splitP);
        this.paintP.setMinimumSize(minimumSize);
        this.menuMB = new JMenuBar();
        this.openFC = new JFileChooser();
        this.saveFC = new JFileChooser();
        JMenu fileM = new JMenu("File");
        fileM.setMnemonic('F');
        JMenuItem openMI = new JMenuItem("Open...");
        openMI.setMnemonic('O');
        openMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.metadataTE.stopCellEditing();
                self.openFC.setFileFilter(new FileNameExtensionFilter("B16 File, TIFF File, PCORAW File", "b16", "tif", "tiff", "pcoraw"));
                if (self.openFC.getSelectedFile() != null) {
                    self.openFC.setCurrentDirectory(GuiExample.this.openFC.getSelectedFile().getParentFile());
                }
                if (self.openFC.showOpenDialog(self) == 0) {
                    File file = self.openFC.getSelectedFile();
                    BufferedImage image = null;
                    Object reader = null;
                    boolean isB16 = false;
                    boolean isTiff = false;
                    boolean isPcoraw = false;
                    try {
                        ImageInputStream iis = ImageIO.createImageInputStream(file);
                        B16ImageReaderSpi b16Spi = new B16ImageReaderSpi();
                        TIFFImageReaderSpi tiffSpi = new TIFFImageReaderSpi();
                        if (b16Spi.canDecodeInput((Object)iis)) {
                            isB16 = true;
                            reader = new B16ImageReader();
                        } else if (tiffSpi.canDecodeInput((Object)iis)) {
                            isTiff = true;
                            reader = new TIFFImageReaderSpi().createReaderInstance();
                        } else if (".pcoraw".equalsIgnoreCase(file.getPath().substring(file.getPath().lastIndexOf(".")))) {
                            isPcoraw = true;
                            reader = new TIFFImageReaderSpi().createReaderInstance();
                        } else {
                            JOptionPane.showMessageDialog(self, "File cannot be opened.", "Error", 0);
                            return;
                        }
                        ((ImageReader)reader).setInput(iis);
                        self.imageContainer = ((ImageReader)reader).readAll(0, ((ImageReader)reader).getDefaultReadParam());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    if (self.imageContainer != null) {
                        image = (BufferedImage)self.imageContainer.getRenderedImage();
                        if (isB16) {
                            self.metadata = (PcoIIOMetadata)self.imageContainer.getMetadata();
                        } else {
                            TIFFImageMetadata tim = (TIFFImageMetadata)self.imageContainer.getMetadata();
                            B16ImageWriter writer = new B16ImageWriter();
                            ImageTypeSpecifier imageType = null;
                            try {
                                imageType = ((ImageReader)reader).getImageTypes(0).next();
                                self.metadata = (PcoIIOMetadata)writer.convertImageMetadata((IIOMetadata)tim, imageType, null);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        double aspectRatio = (double)image.getWidth() / (double)image.getHeight();
                        String newTitle = "PCO.java Example Application - " + file.getName();
                        self.setTitle(newTitle);
                        newTitle = file.getName();
                        if (isTiff) {
                            if (((GuiExample)self).metadata.getBildStruct().bitRes == 16 && !((GuiExample)self).metadata.getBildStruct().isColor) {
                                newTitle = newTitle + " (16-Bit grayscale), convertible in B16";
                                self.saveMI.setEnabled(true);
                            } else {
                                newTitle = newTitle + " (";
                                newTitle = newTitle + ((GuiExample)self).metadata.getBildStruct().bitRes;
                                newTitle = newTitle + "-Bit ";
                                newTitle = ((GuiExample)self).metadata.getBildStruct().isColor ? newTitle + "RGB)" : newTitle + "grayscale)";
                                newTitle = newTitle + ", not convertible in B16";
                                self.saveMI.setEnabled(false);
                            }
                        } else {
                            self.saveMI.setEnabled(true);
                        }
                        self.statusL.setText(newTitle);
                        self.setSize(new Dimension((int)(800.0 * aspectRatio), 500));
                        self.getPaintP().setImage(image);
                        self.metadataTM.setMetadataBean(GuiExample.this.metadata.getBildStruct());
                        self.metadataTM.setLoaded(true);
                        self.metadataTM.fireTableDataChanged();
                        self.showMetadataMI.setEnabled(true);
                        self.repaint();
                    }
                }
            }
        });
        this.saveMI = new JMenuItem("Save...");
        this.saveMI.setEnabled(false);
        this.saveMI.setMnemonic('S');
        this.saveMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.metadataTE.stopCellEditing();
                if (self.saveFC.getSelectedFile() != null) {
                    self.saveFC.setCurrentDirectory(GuiExample.this.saveFC.getSelectedFile().getParentFile());
                }
                self.saveFC.setFileFilter(new FileNameExtensionFilter("B16 File", "b16"));
                boolean closeSaveDialog = false;
                File file = null;
                while (!closeSaveDialog) {
                    if (self.saveFC.showSaveDialog(self) == 0) {
                        file = self.saveFC.getSelectedFile();
                        if (!file.getName().endsWith("b16") && !file.getName().endsWith("B16")) {
                            file = new File(file.getParentFile(), file.getName() + ".b16");
                        }
                        if (file.exists()) {
                            int result = JOptionPane.showOptionDialog(self, "File exists. Do you want to overwrite it?", "Overwrite", 0, 3, null, null, null);
                            if (result != 0) continue;
                            closeSaveDialog = true;
                            continue;
                        }
                        closeSaveDialog = true;
                        continue;
                    }
                    return;
                }
                try {
                    B16ImageWriter writer = new B16ImageWriter();
                    writer.setOutput((Object)ImageIO.createImageOutputStream(file));
                    writer.write(GuiExample.this.imageContainer);
                    JOptionPane.showMessageDialog(self, "Image saved");
                    self.openFC.setSelectedFile(file);
                    self.statusL.setText(file.getName());
                    String newTitle = "PCO.java Example Application - " + file.getName();
                    self.setTitle(newTitle);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.showMetadataMI = new JMenuItem("Show metadata");
        this.showMetadataMI.setEnabled(false);
        this.showMetadataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.metadataTE.stopCellEditing();
                JDialog dialog = new JDialog(self, "Metadata in the native XML", true);
                JTextArea metadataTA = new JTextArea();
                GuiExample.displayMetadata(self.metadata.getAsTree(self.metadata.getNativeMetadataFormatName()));
                JScrollPane metadataSP = new JScrollPane(metadataTA);
                JPanel contentPane = new JPanel(new BorderLayout());
                contentPane.add((Component)metadataSP, "Center");
                contentPane.setOpaque(true);
                dialog.setContentPane(contentPane);
                dialog.setSize(new Dimension(600, 850));
                dialog.setLocationRelativeTo(self);
                metadataTA.setText(sb.toString());
                metadataTA.setCaretPosition(0);
                dialog.setVisible(true);
            }
        });
        JMenuItem exitMI = new JMenuItem("Exit");
        exitMI.setMnemonic('x');
        exitMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.dispose();
            }
        });
        fileM.add(openMI);
        fileM.add(this.saveMI);
        fileM.add(new JSeparator());
        fileM.add(exitMI);
        this.menuMB.add(fileM);
        this.setJMenuBar(this.menuMB);
        JPanel statusBar = new JPanel(new BorderLayout());
        statusBar.setBorder(new BevelBorder(1));
        this.statusL = new JLabel(" ");
        statusBar.add((Component)this.statusL, "Before");
        this.add((Component)statusBar, "South");
        this.setVisible(true);
    }

    public void switchImage(int number) throws Exception {
        this.curImgIndex = number;
        BufferedImage bi = this.reader.read(number);
        this.curImageTF.setText("" + number);
        this.paintP.setImage(bi);
        if (number == 0) {
            this.leftB.setEnabled(false);
        } else {
            this.leftB.setEnabled(true);
        }
        if (number == this.requiredImages - 1) {
            this.rightB.setEnabled(false);
        } else {
            this.rightB.setEnabled(true);
        }
        this.imageContainer = new IIOImage(bi, null, null);
        if (this.images.get(number).getMetadata().getPcoMetadataStruct() != null) {
            BildStruct bildStruct = this.images.get(number).getMetadata().getPcoMetadataStruct().getBackingBildStruct();
            this.metadataTM.setMetadataBean(bildStruct);
            this.metadataTM.setLoaded(true);
            this.metadataTM.fireTableDataChanged();
            this.showMetadataMI.setEnabled(true);
            this.imageContainer.setMetadata((IIOMetadata)new PcoIIOMetadata(bildStruct));
        }
        this.repaint();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiExample example = new GuiExample();
            }
        });
    }

    private PaintPanel getPaintP() {
        return this.paintP;
    }

    private MetadataTableModel getMetadataTM() {
        return this.metadataTM;
    }

    private static void displayMetadata(Node root) {
        sb = new StringBuilder();
        GuiExample.displayMetadata(root, 0);
    }

    private static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            sb.append("    ");
        }
    }

    private static void displayMetadata(Node node, int level) {
        Node child;
        GuiExample.indent(level);
        sb.append("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                sb.append(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            sb.append(">\n");
            while (child != null) {
                GuiExample.displayMetadata(child, level + 1);
                child = child.getNextSibling();
            }
            GuiExample.indent(level);
            sb.append("</" + node.getNodeName() + ">\n");
        } else {
            sb.append("/>\n");
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.camera != null) {
            try {
                this.camera.close();
            }
            catch (PcoException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error by closing the camera", 0);
                return;
            }
        }
    }
}

