/*
 * Decompiled with CFR 0.152.
 */
package de.pco.imageio;

import de.pco.common.MetadataBean;
import de.pco.common.Timestamp;
import de.pco.common.enums.B16Version;
import de.pco.common.enums.CameraSubtype;
import de.pco.common.enums.CameraSyncMode;
import de.pco.common.enums.CameraType;
import de.pco.common.enums.ColorPatternType;
import de.pco.common.enums.ImageTimeStatus;
import de.pco.common.enums.ImageType;
import de.pco.common.enums.SyncStatus;
import de.pco.common.enums.Timebase;
import de.pco.common.enums.TimestampPosition;
import de.pco.common.enums.TriggerMode;
import java.util.StringTokenizer;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class PcoIIOMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "de_pco_imageio_1.0";
    private MetadataBean metadataBean;

    public PcoIIOMetadata(MetadataBean metadataBean) {
        super(true, nativeMetadataFormatName, "de.pco.imageio.PcoIIOMetadataFormat", null, null);
        this.metadataBean = metadataBean;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode rootNode = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode node = null;
        IIOMetadataNode chromaNode = new IIOMetadataNode("Chroma");
        node = new IIOMetadataNode("IsColor");
        node.setAttribute("value", "" + this.metadataBean.isColor);
        chromaNode.appendChild(node);
        IIOMetadataNode bwNode = new IIOMetadataNode("BlackWhite");
        node = new IIOMetadataNode("MainValues");
        node.setAttribute("min", "" + this.metadataBean.bwMin);
        node.setAttribute("max", "" + this.metadataBean.bwMax);
        node.setAttribute("lut", "" + this.metadataBean.bwLut);
        node.setAttribute("gammaLut", "" + this.metadataBean.gammaLut);
        bwNode.appendChild(node);
        node = new IIOMetadataNode("SecondaryValues");
        node.setAttribute("min2", "" + this.metadataBean.bwMin2);
        node.setAttribute("max2", "" + this.metadataBean.bwMax2);
        node.setAttribute("lut2", "" + this.metadataBean.bwLut2);
        node.setAttribute("gammaLut2", "" + this.metadataBean.gammaLut2);
        bwNode.appendChild(node);
        chromaNode.appendChild(bwNode);
        IIOMetadataNode colorNode = new IIOMetadataNode("Color");
        colorNode.setAttribute("pattern", "" + this.metadataBean.colorPattern);
        colorNode.setAttribute("patternType", "" + (Object)((Object)this.metadataBean.colorPatternType));
        IIOMetadataNode values1Node = new IIOMetadataNode("MainValues");
        values1Node.setAttribute("lut", "" + this.metadataBean.colLut);
        values1Node.setAttribute("gammaLut", "" + this.metadataBean.gammaLutC);
        node = new IIOMetadataNode("Red");
        node.setAttribute("min", "" + this.metadataBean.rMin);
        node.setAttribute("max", "" + this.metadataBean.rMax);
        values1Node.appendChild(node);
        node = new IIOMetadataNode("Green");
        node.setAttribute("min", "" + this.metadataBean.gMin);
        node.setAttribute("max", "" + this.metadataBean.gMax);
        values1Node.appendChild(node);
        node = new IIOMetadataNode("Blue");
        node.setAttribute("min", "" + this.metadataBean.bMin);
        node.setAttribute("max", "" + this.metadataBean.bMax);
        values1Node.appendChild(node);
        colorNode.appendChild(values1Node);
        IIOMetadataNode values2Node = new IIOMetadataNode("SecondaryValues");
        values2Node.setAttribute("lut2", "" + this.metadataBean.colLut2);
        values2Node.setAttribute("gammaLut2", "" + this.metadataBean.gammaLutC2);
        node = new IIOMetadataNode("Red");
        node.setAttribute("min2", "" + this.metadataBean.rMin2);
        node.setAttribute("max2", "" + this.metadataBean.rMax2);
        values2Node.appendChild(node);
        node = new IIOMetadataNode("Green");
        node.setAttribute("min2", "" + this.metadataBean.gMin2);
        node.setAttribute("max2", "" + this.metadataBean.gMax2);
        values2Node.appendChild(node);
        node = new IIOMetadataNode("Blue");
        node.setAttribute("min2", "" + this.metadataBean.bMin2);
        node.setAttribute("max2", "" + this.metadataBean.bMax2);
        values2Node.appendChild(node);
        colorNode.appendChild(values2Node);
        node = new IIOMetadataNode("Saturation");
        if (this.metadataBean.iSaturation == 0) {
            node.setAttribute("value", "" + this.metadataBean.dSaturation);
        } else {
            node.setAttribute("value", "" + this.metadataBean.iSaturation);
        }
        colorNode.appendChild(node);
        node = new IIOMetadataNode("Vibrance");
        node.setAttribute("value", "" + this.metadataBean.vibrance);
        colorNode.appendChild(node);
        node = new IIOMetadataNode("Temperature");
        node.setAttribute("value", "" + this.metadataBean.colorTemp);
        colorNode.appendChild(node);
        node = new IIOMetadataNode("Tint");
        node.setAttribute("value", "" + this.metadataBean.colorTint);
        colorNode.appendChild(node);
        IIOMetadataNode cccNode = new IIOMetadataNode("ColorCorrectionCoefficients");
        node = new IIOMetadataNode("Row1");
        node.setAttribute("col1", "" + this.metadataBean.colorCoeff.a11);
        node.setAttribute("col2", "" + this.metadataBean.colorCoeff.a12);
        node.setAttribute("col3", "" + this.metadataBean.colorCoeff.a13);
        cccNode.appendChild(node);
        node = new IIOMetadataNode("Row2");
        node.setAttribute("col1", "" + this.metadataBean.colorCoeff.a21);
        node.setAttribute("col2", "" + this.metadataBean.colorCoeff.a22);
        node.setAttribute("col3", "" + this.metadataBean.colorCoeff.a23);
        cccNode.appendChild(node);
        node = new IIOMetadataNode("Row3");
        node.setAttribute("col1", "" + this.metadataBean.colorCoeff.a31);
        node.setAttribute("col2", "" + this.metadataBean.colorCoeff.a32);
        node.setAttribute("col3", "" + this.metadataBean.colorCoeff.a33);
        cccNode.appendChild(node);
        colorNode.appendChild(cccNode);
        chromaNode.appendChild(colorNode);
        node = new IIOMetadataNode("Gamma");
        node.setAttribute("value", "" + this.metadataBean.gamma);
        chromaNode.appendChild(node);
        node = new IIOMetadataNode("Contrast");
        node.setAttribute("value", "" + this.metadataBean.contrast);
        chromaNode.appendChild(node);
        if (this.metadataBean.randomStart != 0L) {
            node = new IIOMetadataNode("RandomizedLut");
            node.setAttribute("start", "" + this.metadataBean.randomStart);
            node.setAttribute("index", "" + this.metadataBean.randomIndex);
            chromaNode.appendChild(node);
        }
        rootNode.appendChild(chromaNode);
        if (this.metadataBean.compression != 0L) {
            IIOMetadataNode compressionNode = new IIOMetadataNode("Compression");
            node = new IIOMetadataNode("CompressionTypeName");
            node.setAttribute("value", "Camware Direct-Record-To-File");
            compressionNode.appendChild(node);
            node = new IIOMetadataNode("CompressionNumber");
            node.setAttribute("value", "" + this.metadataBean.compression);
            compressionNode.appendChild(node);
            node = new IIOMetadataNode("CompressionVersion");
            node.setAttribute("value", "" + this.metadataBean.compressionVersion);
            compressionNode.appendChild(node);
            node = new IIOMetadataNode("PredictorStart");
            node.setAttribute("value", "" + this.metadataBean.predictorStart);
            compressionNode.appendChild(node);
            rootNode.appendChild(compressionNode);
        }
        IIOMetadataNode dataNode = new IIOMetadataNode("Data");
        node = new IIOMetadataNode("SignificantBitsPerSample");
        node.setAttribute("value", "" + this.metadataBean.bitRes);
        dataNode.appendChild(node);
        node = new IIOMetadataNode("AlignUpper");
        node.setAttribute("value", "" + this.metadataBean.alignUpper);
        dataNode.appendChild(node);
        rootNode.appendChild(dataNode);
        IIOMetadataNode dimesionNode = new IIOMetadataNode("Dimension");
        node = new IIOMetadataNode("HorizontalImageSize");
        node.setAttribute("value", "" + this.metadataBean.xRes);
        dimesionNode.appendChild(node);
        node = new IIOMetadataNode("VerticalImageSize");
        node.setAttribute("value", "" + this.metadataBean.yRes);
        dimesionNode.appendChild(node);
        if (this.metadataBean.imageSizeXoffset != 0) {
            node = new IIOMetadataNode("HorizontalOffset");
            node.setAttribute("value", "" + this.metadataBean.imageSizeXoffset);
            dimesionNode.appendChild(node);
        }
        if (this.metadataBean.imageSizeYoffset != 0) {
            node = new IIOMetadataNode("VerticalOffset");
            node.setAttribute("value", "" + this.metadataBean.imageSizeYoffset);
            dimesionNode.appendChild(node);
        }
        rootNode.appendChild(dimesionNode);
        IIOMetadataNode documentNode = new IIOMetadataNode("Document");
        node = new IIOMetadataNode("FormatVersion");
        node.setAttribute("value", "" + (double)this.metadataBean.version.getValue() / 100.0);
        documentNode.appendChild(node);
        node = new IIOMetadataNode("ImageCreationTime");
        node.setAttribute("year", "" + this.metadataBean.time.year);
        node.setAttribute("month", "" + this.metadataBean.time.month);
        node.setAttribute("day", "" + this.metadataBean.time.day);
        node.setAttribute("hour", "" + this.metadataBean.time.hour);
        node.setAttribute("minute", "" + this.metadataBean.time.minute);
        node.setAttribute("second", "" + this.metadataBean.time.second);
        documentNode.appendChild(node);
        node = new IIOMetadataNode("ImageAcquisitionTimeInMillis");
        node.setAttribute("value", "" + this.metadataBean.ticks);
        documentNode.appendChild(node);
        node = new IIOMetadataNode("TimestampPosition");
        node.setAttribute("value", "" + (Object)((Object)this.metadataBean.timestampPosition));
        documentNode.appendChild(node);
        node = new IIOMetadataNode("ImageCounter");
        node.setAttribute("value", "" + this.metadataBean.imageCounter);
        documentNode.appendChild(node);
        node = new IIOMetadataNode("IsDoubleShutter");
        node.setAttribute("value", "" + this.metadataBean.isDouble);
        documentNode.appendChild(node);
        node = new IIOMetadataNode("ThisIsT0");
        node.setAttribute("value", "" + this.metadataBean.thisIsT0);
        documentNode.appendChild(node);
        node = new IIOMetadataNode("WeHaveT0");
        node.setAttribute("value", "" + this.metadataBean.weHaveT0);
        documentNode.appendChild(node);
        if (this.metadataBean.diffToT0 != 0) {
            node = new IIOMetadataNode("DiffToT0");
            node.setAttribute("value", "" + this.metadataBean.diffToT0);
            documentNode.appendChild(node);
        }
        rootNode.appendChild(documentNode);
        IIOMetadataNode textNode = new IIOMetadataNode("Text");
        node = new IIOMetadataNode("TextEntry");
        node.setAttribute("keyword", "TextInsideImage");
        node.setAttribute("value", this.metadataBean.text);
        textNode.appendChild(node);
        if (this.metadataBean.hasMetaData) {
            IIOMetadataNode cameraMetadataNode = new IIOMetadataNode("CameraMetadata");
            if (this.metadataBean.sensorConvFactor != 0) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "SensorConvFactor");
                node.setAttribute("value", "" + this.metadataBean.sensorConvFactor);
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.cameraType != CameraType.UNDEFINED) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "CameraType");
                node.setAttribute("value", "" + (Object)((Object)this.metadataBean.cameraType));
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.darkOffset != 65535) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "DarkOffset");
                node.setAttribute("value", "" + this.metadataBean.darkOffset);
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.imageTimeUs != 0) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "ImageTimeUs");
                node.setAttribute("value", "" + this.metadataBean.imageTimeUs);
                cameraMetadataNode.appendChild(node);
            }
            node = new IIOMetadataNode("TextEntry");
            node.setAttribute("keyword", "ImageTimeStatus");
            node.setAttribute("value", "" + (Object)((Object)this.metadataBean.imageTimeStatus));
            cameraMetadataNode.appendChild(node);
            node = new IIOMetadataNode("TextEntry");
            node.setAttribute("keyword", "ExposureTimebase");
            node.setAttribute("value", "" + (Object)((Object)this.metadataBean.exposureTimebase));
            cameraMetadataNode.appendChild(node);
            if (this.metadataBean.sensorTemperature != Short.MAX_VALUE) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "SensorTemperature");
                node.setAttribute("value", "" + this.metadataBean.sensorTemperature);
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.exposureTime != 0L) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "ExposureTime");
                node.setAttribute("value", "" + this.metadataBean.exposureTime);
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.framerateMilliHz != 0L) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "FramerateMilliHz");
                node.setAttribute("value", "" + this.metadataBean.framerateMilliHz);
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.binningX != 0) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "BinningX");
                node.setAttribute("value", "" + this.metadataBean.binningX);
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.binningY != 0) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "BinningY");
                node.setAttribute("value", "" + this.metadataBean.binningY);
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.triggerMode != TriggerMode.AUTOTRIGGER) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "TriggerMode");
                node.setAttribute("value", "" + (Object)((Object)this.metadataBean.triggerMode));
                cameraMetadataNode.appendChild(node);
            }
            node = new IIOMetadataNode("TextEntry");
            node.setAttribute("keyword", "CameraSyncMode");
            node.setAttribute("value", "" + (Object)((Object)this.metadataBean.cameraSyncMode));
            cameraMetadataNode.appendChild(node);
            if (this.metadataBean.sensorReadoutFrequency != 0L) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "SensorReadoutFrequency");
                node.setAttribute("value", "" + this.metadataBean.sensorReadoutFrequency);
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.cameraSerialNo != 0L) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "CameraSerialNo");
                node.setAttribute("value", "" + this.metadataBean.cameraSerialNo);
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.syncStatus == SyncStatus.LOCKED) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "SyncStatus");
                node.setAttribute("value", "" + (Object)((Object)this.metadataBean.syncStatus));
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.imageType != ImageType.UNDEFINED) {
                node = new IIOMetadataNode("TextEntry");
                node.setAttribute("keyword", "ImageType");
                node.setAttribute("value", "" + (Object)((Object)this.metadataBean.imageType));
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.cameraSubtype != CameraSubtype.UNDEFINED) {
                node = new IIOMetadataNode("CameraSubtype");
                node.setAttribute("value", "" + (Object)((Object)this.metadataBean.cameraSubtype));
                cameraMetadataNode.appendChild(node);
            }
            if (this.metadataBean.eventNumber != 0L) {
                node = new IIOMetadataNode("EventNumber");
                node.setAttribute("value", "" + this.metadataBean.eventNumber);
                cameraMetadataNode.appendChild(node);
            }
            textNode.appendChild(cameraMetadataNode);
            rootNode.appendChild(textNode);
        }
        return rootNode;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals(nativeMetadataFormatName)) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    private void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals(nativeMetadataFormatName)) {
            this.fatal(node, "Root must be de_pco_imageio_1.0");
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            String childName;
            Node child;
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    childName = child.getNodeName();
                    if (childName.equals("IsColor")) {
                        this.metadataBean.isColor = this.getBooleanAttribute(child, "value");
                    } else if (childName.equals("BlackWhite")) {
                        for (Node nodeInsideBW = child.getFirstChild(); nodeInsideBW != null; nodeInsideBW = nodeInsideBW.getNextSibling()) {
                            String nodeInsideBWname = nodeInsideBW.getNodeName();
                            if (nodeInsideBWname.equals("MainValues")) {
                                this.metadataBean.bwMin = this.getIntAttribute(nodeInsideBW, "min");
                                this.metadataBean.bwMax = this.getIntAttribute(nodeInsideBW, "max");
                                this.metadataBean.bwLut = this.getIntAttribute(nodeInsideBW, "lut");
                                this.metadataBean.gammaLut = this.getFloatAttribute(nodeInsideBW, "gammaLut");
                                continue;
                            }
                            if (!nodeInsideBWname.equals("SecondaryValues")) continue;
                            this.metadataBean.bwMin2 = this.getIntAttribute(nodeInsideBW, "min2");
                            this.metadataBean.bwMax2 = this.getIntAttribute(nodeInsideBW, "max2");
                            this.metadataBean.bwLut2 = this.getIntAttribute(nodeInsideBW, "lut2");
                            this.metadataBean.gammaLut2 = this.getFloatAttribute(nodeInsideBW, "gammaLut2");
                        }
                    } else if (childName.equals("Color")) {
                        this.metadataBean.colorPattern = this.getIntAttribute(child, "pattern");
                        this.metadataBean.colorPatternType = ColorPatternType.valueOf(this.getAttribute(child, "patternType"));
                        for (Node nodeInsideColor = child.getFirstChild(); nodeInsideColor != null; nodeInsideColor = nodeInsideColor.getNextSibling()) {
                            String nodeInsideColorMainName;
                            Node nodeInsideColorMain;
                            String nodeInsideColorname = nodeInsideColor.getNodeName();
                            if (nodeInsideColorname.equals("MainValues")) {
                                this.metadataBean.colLut = this.getIntAttribute(nodeInsideColor, "lut");
                                this.metadataBean.gammaLutC = this.getFloatAttribute(nodeInsideColor, "gammaLut");
                                for (nodeInsideColorMain = nodeInsideColor.getFirstChild(); nodeInsideColorMain != null; nodeInsideColorMain = nodeInsideColorMain.getNextSibling()) {
                                    nodeInsideColorMainName = nodeInsideColorMain.getNodeName();
                                    if (nodeInsideColorMainName.equals("Red")) {
                                        this.metadataBean.rMin = this.getIntAttribute(nodeInsideColorMain, "min");
                                        this.metadataBean.rMax = this.getIntAttribute(nodeInsideColorMain, "max");
                                        continue;
                                    }
                                    if (nodeInsideColorMainName.equals("Green")) {
                                        this.metadataBean.gMin = this.getIntAttribute(nodeInsideColorMain, "min");
                                        this.metadataBean.gMax = this.getIntAttribute(nodeInsideColorMain, "max");
                                        continue;
                                    }
                                    if (!nodeInsideColorMainName.equals("Blue")) continue;
                                    this.metadataBean.bMin = this.getIntAttribute(nodeInsideColorMain, "min");
                                    this.metadataBean.bMax = this.getIntAttribute(nodeInsideColorMain, "max");
                                }
                                continue;
                            }
                            if (nodeInsideColorname.equals("SecondaryValues")) {
                                this.metadataBean.colLut2 = this.getIntAttribute(nodeInsideColor, "lut2");
                                this.metadataBean.gammaLutC2 = this.getFloatAttribute(nodeInsideColor, "gammaLut2");
                                for (nodeInsideColorMain = nodeInsideColor.getFirstChild(); nodeInsideColorMain != null; nodeInsideColorMain = nodeInsideColorMain.getNextSibling()) {
                                    nodeInsideColorMainName = nodeInsideColorMain.getNodeName();
                                    if (nodeInsideColorMainName.equals("Red")) {
                                        this.metadataBean.rMin2 = this.getIntAttribute(nodeInsideColorMain, "min2");
                                        this.metadataBean.rMax2 = this.getIntAttribute(nodeInsideColorMain, "max2");
                                        continue;
                                    }
                                    if (nodeInsideColorMainName.equals("Green")) {
                                        this.metadataBean.gMin2 = this.getIntAttribute(nodeInsideColorMain, "min2");
                                        this.metadataBean.gMax2 = this.getIntAttribute(nodeInsideColorMain, "max2");
                                        continue;
                                    }
                                    if (!nodeInsideColorMainName.equals("Blue")) continue;
                                    this.metadataBean.bMin2 = this.getIntAttribute(nodeInsideColorMain, "min2");
                                    this.metadataBean.bMax2 = this.getIntAttribute(nodeInsideColorMain, "max2");
                                }
                                continue;
                            }
                            if (nodeInsideColorname.equals("Saturation")) {
                                Float saturation = Float.valueOf(this.getFloatAttribute(nodeInsideColor, "value"));
                                if ((double)saturation.floatValue() == Math.floor(saturation.floatValue())) {
                                    this.metadataBean.iSaturation = (int)Math.floor(saturation.floatValue());
                                    this.metadataBean.dSaturation = Math.floor(saturation.floatValue());
                                    continue;
                                }
                                this.metadataBean.dSaturation = saturation.floatValue();
                                this.metadataBean.iSaturation = 0;
                                continue;
                            }
                            if (nodeInsideColorname.equals("Vibrance")) {
                                this.metadataBean.vibrance = this.getIntAttribute(nodeInsideColor, "value");
                                continue;
                            }
                            if (nodeInsideColorname.equals("Temperature")) {
                                this.metadataBean.colorTemp = this.getIntAttribute(nodeInsideColor, "value");
                                continue;
                            }
                            if (nodeInsideColorname.equals("Tint")) {
                                this.metadataBean.colorTint = this.getIntAttribute(nodeInsideColor, "value");
                                continue;
                            }
                            if (!nodeInsideColorname.equals("ColorCorrectionCoefficients")) continue;
                            for (Node colorCoeff = nodeInsideColor.getFirstChild(); colorCoeff != null; colorCoeff = colorCoeff.getNextSibling()) {
                                String rowName = colorCoeff.getNodeName();
                                if (rowName.equals("Row1")) {
                                    this.metadataBean.colorCoeff.a11 = this.getDoubleAttribute(colorCoeff, "col1");
                                    this.metadataBean.colorCoeff.a12 = this.getDoubleAttribute(colorCoeff, "col2");
                                    this.metadataBean.colorCoeff.a13 = this.getDoubleAttribute(colorCoeff, "col3");
                                    continue;
                                }
                                if (rowName.equals("Row2")) {
                                    this.metadataBean.colorCoeff.a21 = this.getDoubleAttribute(colorCoeff, "col1");
                                    this.metadataBean.colorCoeff.a22 = this.getDoubleAttribute(colorCoeff, "col2");
                                    this.metadataBean.colorCoeff.a23 = this.getDoubleAttribute(colorCoeff, "col3");
                                    continue;
                                }
                                if (!rowName.equals("Row3")) continue;
                                this.metadataBean.colorCoeff.a31 = this.getDoubleAttribute(colorCoeff, "col1");
                                this.metadataBean.colorCoeff.a32 = this.getDoubleAttribute(colorCoeff, "col2");
                                this.metadataBean.colorCoeff.a33 = this.getDoubleAttribute(colorCoeff, "col3");
                            }
                        }
                    }
                    if (childName.equals("Gamma")) {
                        this.metadataBean.gamma = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (childName.equals("Contrast")) {
                        this.metadataBean.contrast = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (!childName.equals("RandomizedLut")) continue;
                    this.metadataBean.randomStart = this.getIntAttribute(child, "start");
                    this.metadataBean.randomIndex = this.getIntAttribute(child, "index");
                }
                continue;
            }
            if (name.equals("Compression")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    childName = child.getNodeName();
                    if (childName.equals("CompressionTypeName")) {
                        String compressionTypeName = this.getStringAttribute(child, "value", null, true);
                        if (!compressionTypeName.equalsIgnoreCase("Camware Direct-Record-To-File")) {
                            this.fatal(child, "CompressionTypeName must be \"Camware Direct-Record-To-File\"");
                            continue;
                        }
                        this.metadataBean.cameraType = CameraType.PCO_FAMILY_EDGE;
                        continue;
                    }
                    if (childName.equals("CompressionNumber")) {
                        this.metadataBean.compression = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (childName.equals("CompressionVersion")) {
                        this.metadataBean.compressionVersion = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (!childName.equals("PredictorStart")) continue;
                    this.metadataBean.predictorStart = this.getIntAttribute(child, "value");
                }
                continue;
            }
            if (name.equals("Data")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    childName = child.getNodeName();
                    if (childName.equals("SignificantBitsPerSample")) {
                        this.metadataBean.bitRes = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (!childName.equals("AlignUpper")) continue;
                    this.metadataBean.alignUpper = this.getBooleanAttribute(child, "value");
                }
                continue;
            }
            if (name.equals("Dimension")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    childName = child.getNodeName();
                    if (childName.equals("HorizontalImageSize")) {
                        this.metadataBean.xRes = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (childName.equals("VerticalImageSize")) {
                        this.metadataBean.yRes = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (childName.equals("HorizontalOffset")) {
                        this.metadataBean.imageSizeXoffset = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (!childName.equals("VerticalOffset")) continue;
                    this.metadataBean.imageSizeYoffset = this.getIntAttribute(child, "value");
                }
                continue;
            }
            if (name.equals("Document")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    childName = child.getNodeName();
                    if (childName.equals("FormatVersion")) {
                        int version = (int)(this.getFloatAttribute(child, "value") * 100.0f);
                        this.metadataBean.version = B16Version.valueOf(version);
                        continue;
                    }
                    if (childName.equals("ImageCreationTime")) {
                        Timestamp t = new Timestamp();
                        t.year = this.getIntAttribute(child, "year");
                        t.month = this.getIntAttribute(child, "month");
                        t.day = this.getIntAttribute(child, "day");
                        t.hour = this.getIntAttribute(child, "hour", 0, false);
                        t.minute = this.getIntAttribute(child, "minute", 0, false);
                        t.second = this.getIntAttribute(child, "second", 0, false);
                        this.metadataBean.time = t;
                        continue;
                    }
                    if (childName.equals("ImageAcquisitionTimeInMillis")) {
                        this.metadataBean.ticks = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (childName.equals("TimestampPosition")) {
                        this.metadataBean.timestampPosition = TimestampPosition.valueOf(this.getAttribute(child, "value"));
                        continue;
                    }
                    if (childName.equals("ImageCounter")) {
                        this.metadataBean.imageCounter = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (childName.equals("IsDoubleShutter")) {
                        this.metadataBean.isDouble = this.getBooleanAttribute(child, "value");
                        continue;
                    }
                    if (childName.equals("ThisIsT0")) {
                        this.metadataBean.thisIsT0 = this.getBooleanAttribute(child, "value");
                        continue;
                    }
                    if (childName.equals("WeHaveT0")) {
                        this.metadataBean.weHaveT0 = this.getBooleanAttribute(child, "value");
                        continue;
                    }
                    if (!childName.equals("DiffToT0")) continue;
                    this.metadataBean.diffToT0 = this.getIntAttribute(child, "value");
                }
                continue;
            }
            if (!name.equals("Text")) continue;
            for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                childName = child.getNodeName();
                if (childName.equals("TextEntry") && this.getAttribute(child, "keyword").equals("TextInsideImage")) {
                    this.metadataBean.text = this.getAttribute(child, "value");
                    continue;
                }
                if (!childName.equals("CameraMetadata")) continue;
                this.metadataBean.hasMetaData = true;
                for (Node metadataChild = child.getFirstChild(); metadataChild != null; metadataChild = metadataChild.getNextSibling()) {
                    String metadataChildName = metadataChild.getNodeName();
                    if (!metadataChildName.equals("TextEntry")) continue;
                    if (this.getAttribute(metadataChild, "keyword").equals("SensorConvFactor")) {
                        this.metadataBean.sensorConvFactor = this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("CameraType")) {
                        this.metadataBean.cameraType = CameraType.valueOf(this.getAttribute(metadataChild, "value"));
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("DarkOffset")) {
                        this.metadataBean.darkOffset = this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("ImageTimeUs")) {
                        this.metadataBean.imageTimeUs = this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("ImageTimeStatus")) {
                        this.metadataBean.imageTimeStatus = ImageTimeStatus.valueOf(this.getAttribute(metadataChild, "value"));
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("ExposureTimebase")) {
                        this.metadataBean.exposureTimebase = Timebase.valueOf(this.getAttribute(metadataChild, "value"));
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("SensorTemperature")) {
                        this.metadataBean.sensorTemperature = (short)this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("ExposureTime")) {
                        this.metadataBean.exposureTime = this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("FramerateMilliHz")) {
                        this.metadataBean.framerateMilliHz = this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("BinningX")) {
                        this.metadataBean.binningX = (byte)this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("BinningY")) {
                        this.metadataBean.binningY = (byte)this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("TriggerMode")) {
                        this.metadataBean.triggerMode = TriggerMode.valueOf(this.getAttribute(metadataChild, "value"));
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("CameraSyncMode")) {
                        this.metadataBean.cameraSyncMode = CameraSyncMode.valueOf(this.getAttribute(metadataChild, "value"));
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("SensorReadoutFrequency")) {
                        this.metadataBean.sensorReadoutFrequency = this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("CameraSerialNo")) {
                        this.metadataBean.cameraSerialNo = this.getIntAttribute(metadataChild, "value");
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("SyncStatus")) {
                        this.metadataBean.syncStatus = SyncStatus.valueOf(this.getAttribute(metadataChild, "value"));
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("ImageType")) {
                        this.metadataBean.imageType = ImageType.valueOf(this.getAttribute(metadataChild, "value"));
                        continue;
                    }
                    if (this.getAttribute(metadataChild, "keyword").equals("CameraSubtype")) {
                        this.metadataBean.cameraSubtype = CameraSubtype.valueOf(this.getAttribute(metadataChild, "value"));
                        continue;
                    }
                    if (!this.getAttribute(metadataChild, "keyword").equals("EventNumber")) continue;
                    this.metadataBean.eventNumber = this.getIntAttribute(metadataChild, "value");
                }
            }
        }
    }

    private void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals("javax_imageio_1.0")) {
            this.fatal(node, "Root must be javax_imageio_1.0");
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            String childName;
            Node child;
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    int gamma;
                    String colorSpaceType;
                    childName = child.getNodeName();
                    if (childName.equals("ColorSpaceType") && !(colorSpaceType = this.getStringAttribute(child, "name", null, true)).equalsIgnoreCase("GRAY")) {
                        this.fatal(child, "ColorSpaceType must be GRAY");
                    }
                    if (!childName.equals("Gamma")) continue;
                    this.metadataBean.gamma = gamma = this.getIntAttribute(child, "value");
                }
                continue;
            }
            if (name.equals("Compression")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    childName = child.getNodeName();
                    if (!childName.equals("CompressionTypeName")) continue;
                    String compressionTypeName = this.getStringAttribute(child, "value", null, true);
                    if (!compressionTypeName.equalsIgnoreCase("Camware Direct-Record-To-File")) {
                        this.fatal(child, "CompressionTypeName must be \"Camware Direct-Record-To-File\"");
                        continue;
                    }
                    this.metadataBean.cameraType = CameraType.PCO_FAMILY_EDGE;
                }
                continue;
            }
            if (name.equals("Data")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    int value;
                    StringTokenizer t;
                    String s;
                    childName = child.getNodeName();
                    if (childName.equals("PlanarConfiguration")) {
                        String planarConfiguration = this.getStringAttribute(child, "value", null, true);
                        if (planarConfiguration.equalsIgnoreCase("TileInterleaved")) continue;
                        this.fatal(child, "PlanarConfiguration must be TileInterleaved");
                        continue;
                    }
                    if (childName.equals("SampleFormat")) {
                        String sampleFormat = this.getStringAttribute(child, "value", null, true);
                        if (sampleFormat.equalsIgnoreCase("UnsignedIntegral")) continue;
                        this.fatal(child, "SampleFormat must be UnsignedIntegral");
                        continue;
                    }
                    if (childName.equals("BitsPerSample")) {
                        s = this.getAttribute(child, "value");
                        t = new StringTokenizer(s);
                        int maxBits = -1;
                        int numTokens = t.countTokens();
                        if (numTokens == 1 && s.equalsIgnoreCase("16")) continue;
                        this.fatal(child, "BitsPerSample must have only one value and it should be 16");
                        continue;
                    }
                    if (!childName.equals("SignificantBitsPerSample")) continue;
                    s = this.getAttribute(child, "value");
                    t = new StringTokenizer(s);
                    int numTokens = t.countTokens();
                    if (numTokens != 1) {
                        this.fatal(child, "Only 1 value allowed in SignificantBitsPerSample");
                        continue;
                    }
                    this.metadataBean.bitRes = value = this.getIntAttribute(child, "value");
                }
                continue;
            }
            if (name.equals("Dimension")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String imageOrientation;
                    childName = child.getNodeName();
                    if (!childName.equals("ImageOrientation") || (imageOrientation = this.getAttribute(child, "value")).equalsIgnoreCase("Normal")) continue;
                    this.fatal(child, "ImageOrientation must be Normal");
                }
                continue;
            }
            if (name.equals("Document")) {
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    childName = child.getNodeName();
                    if (childName.equals("FormatVersion")) {
                        Float formatVersion = Float.valueOf(this.getFloatAttribute(child, "value"));
                        this.metadataBean.version = B16Version.valueOf((int)(formatVersion.floatValue() * 100.0f));
                        continue;
                    }
                    if (childName.equals("SubimageInterpretation")) {
                        String subimageInterpretation = this.getAttribute(child, "value");
                        if (subimageInterpretation.equalsIgnoreCase("SinglePage")) continue;
                        this.fatal(child, "SubimageInterpretation must be SinglePage");
                        continue;
                    }
                    if (!childName.equals("ImageCreationTime")) continue;
                    Timestamp t = new Timestamp();
                    t.year = this.getIntAttribute(child, "year");
                    t.month = this.getIntAttribute(child, "month");
                    t.day = this.getIntAttribute(child, "day");
                    t.hour = this.getIntAttribute(child, "hour", 0, false);
                    t.minute = this.getIntAttribute(child, "minute", 0, false);
                    t.second = this.getIntAttribute(child, "second", 0, false);
                    this.metadataBean.time = t;
                }
                continue;
            }
            if (!name.equals("Text")) continue;
            for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                childName = child.getNodeName();
                if (!childName.equals("TextEntry")) continue;
                String keyword = this.getAttribute(child, "keyword", "", false);
                String value = this.getAttribute(child, "value");
                if (keyword.equals("TextInsideImage")) {
                    this.metadataBean.text = value;
                    continue;
                }
                if (keyword.equals("CameraSerialNo")) {
                    this.metadataBean.cameraSerialNo = Long.parseLong(value);
                    continue;
                }
                if (keyword.equals("CameraType")) {
                    this.metadataBean.cameraType = CameraType.valueOf(value);
                    continue;
                }
                if (keyword.equals("CameraSubtype")) {
                    if (!this.metadataBean.cameraType.toString().startsWith("PCO_FAMILY")) continue;
                    this.metadataBean.cameraSubtype = CameraSubtype.valueOf(value);
                    continue;
                }
                if (keyword.equals("FramerateMilliHz")) {
                    this.metadataBean.framerateMilliHz = Long.parseLong(value);
                    continue;
                }
                if (!keyword.equals("SensorReadoutFrequency")) continue;
                this.metadataBean.sensorReadoutFrequency = Long.parseLong(value);
            }
        }
    }

    @Override
    public void reset() {
        this.metadataBean = new MetadataBean();
    }

    public int getWidth() {
        return this.metadataBean.xRes;
    }

    public int getHeight() {
        return this.metadataBean.yRes;
    }

    public MetadataBean getMetadataBean() {
        return this.metadataBean;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode chroma_node = new IIOMetadataNode("Chroma");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("ColorSpaceType");
        node.setAttribute("name", "GRAY");
        chroma_node.appendChild(node);
        node = new IIOMetadataNode("Gamma");
        node.setAttribute("value", "" + this.metadataBean.gamma);
        chroma_node.appendChild(node);
        node = new IIOMetadataNode("BlackIsZero");
        chroma_node.appendChild(node);
        return chroma_node;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        if (this.metadataBean.compression != 0L) {
            IIOMetadataNode compression_node = new IIOMetadataNode("Compression");
            IIOMetadataNode node = null;
            node = new IIOMetadataNode("CompressionTypeName");
            node.setAttribute("value", "Camware Direct-Record-To-File");
            compression_node.appendChild(node);
            node = new IIOMetadataNode("Lossless");
            node.setAttribute("value", "FALSE");
            compression_node.appendChild(node);
            return compression_node;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode data_node = new IIOMetadataNode("Data");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("PlanarConfiguration");
        node.setAttribute("value", "TileInterleaved");
        data_node.appendChild(node);
        node = new IIOMetadataNode("SampleFormat");
        node.setAttribute("value", "UnsignedIntegral");
        data_node.appendChild(node);
        node = new IIOMetadataNode("BitsPerSample");
        node.setAttribute("value", "16");
        data_node.appendChild(node);
        node = new IIOMetadataNode("SignificantBitsPerSample");
        node.setAttribute("value", "" + this.metadataBean.bitRes);
        data_node.appendChild(node);
        return data_node;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode dimension_node = new IIOMetadataNode("Dimension");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("ImageOrientation");
        node.setAttribute("value", "Normal");
        dimension_node.appendChild(node);
        return dimension_node;
    }

    @Override
    protected IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode document_node = new IIOMetadataNode("Document");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("FormatVersion");
        node.setAttribute("value", "" + (double)this.metadataBean.version.getValue() / 100.0);
        document_node.appendChild(node);
        node = new IIOMetadataNode("SubimageInterpretation");
        node.setAttribute("value", "SinglePage");
        document_node.appendChild(node);
        node = new IIOMetadataNode("ImageCreationTime");
        node.setAttribute("year", "" + this.metadataBean.time.year);
        node.setAttribute("month", "" + this.metadataBean.time.month);
        node.setAttribute("day", "" + this.metadataBean.time.day);
        node.setAttribute("hour", "" + this.metadataBean.time.hour);
        node.setAttribute("minute", "" + this.metadataBean.time.minute);
        node.setAttribute("second", "" + this.metadataBean.time.second);
        document_node.appendChild(node);
        return document_node;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode text_node = new IIOMetadataNode("Text");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("TextEntry");
        node.setAttribute("keyword", "TextInsideImage");
        node.setAttribute("value", "" + this.metadataBean.text);
        text_node.appendChild(node);
        node = new IIOMetadataNode("TextEntry");
        node.setAttribute("keyword", "CameraSerialNo");
        node.setAttribute("value", "" + this.metadataBean.cameraSerialNo);
        text_node.appendChild(node);
        node = new IIOMetadataNode("TextEntry");
        node.setAttribute("keyword", "CameraType");
        node.setAttribute("value", "" + (Object)((Object)this.metadataBean.cameraType));
        text_node.appendChild(node);
        if (this.metadataBean.cameraSubtype != CameraSubtype.UNDEFINED) {
            node = new IIOMetadataNode("TextEntry");
            node.setAttribute("keyword", "CameraSubtype");
            node.setAttribute("value", "" + (Object)((Object)this.metadataBean.cameraSubtype));
            text_node.appendChild(node);
        }
        node = new IIOMetadataNode("TextEntry");
        node.setAttribute("keyword", "FrameRateMilliHz");
        node.setAttribute("value", "" + this.metadataBean.framerateMilliHz);
        text_node.appendChild(node);
        node = new IIOMetadataNode("TextEntry");
        node.setAttribute("keyword", "SensorReadoutFrequency");
        node.setAttribute("value", "" + this.metadataBean.sensorReadoutFrequency);
        text_node.appendChild(node);
        return text_node;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    private void fatal(Node node, String reason) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(reason, node);
    }

    private String getStringAttribute(Node node, String name, String defaultValue, boolean required) throws IIOInvalidTreeException {
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            this.fatal(node, "Required attribute " + name + " not present!");
        }
        return attr.getNodeValue();
    }

    private int getIntAttribute(Node node, String name, int defaultValue, boolean required) throws IIOInvalidTreeException {
        String value = this.getStringAttribute(node, name, null, required);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    private float getFloatAttribute(Node node, String name, float defaultValue, boolean required) throws IIOInvalidTreeException {
        String value = this.getStringAttribute(node, name, null, required);
        if (value == null) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    private double getDoubleAttribute(Node node, String name, double defaultValue, boolean required) throws IIOInvalidTreeException {
        String value = this.getStringAttribute(node, name, null, required);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    private int getIntAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getIntAttribute(node, name, -1, true);
    }

    private float getFloatAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getFloatAttribute(node, name, -1.0f, true);
    }

    private double getDoubleAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getDoubleAttribute(node, name, -1.0, true);
    }

    private boolean getBooleanAttribute(Node node, String name, boolean defaultValue, boolean required) throws IIOInvalidTreeException {
        String value;
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            this.fatal(node, "Required attribute " + name + " not present!");
        }
        if ((value = attr.getNodeValue()).equals("TRUE") || value.equals("true")) {
            return true;
        }
        if (value.equals("FALSE") || value.equals("false")) {
            return false;
        }
        this.fatal(node, "Attribute " + name + " must be 'TRUE' or 'FALSE'!");
        return false;
    }

    private boolean getBooleanAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getBooleanAttribute(node, name, false, true);
    }

    private int getEnumeratedAttribute(Node node, String name, String[] legalNames, int defaultValue, boolean required) throws IIOInvalidTreeException {
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            this.fatal(node, "Required attribute " + name + " not present!");
        }
        String value = attr.getNodeValue();
        for (int i = 0; i < legalNames.length; ++i) {
            if (!value.equals(legalNames[i])) continue;
            return i;
        }
        this.fatal(node, "Illegal value for attribute " + name + "!");
        return -1;
    }

    private int getEnumeratedAttribute(Node node, String name, String[] legalNames) throws IIOInvalidTreeException {
        return this.getEnumeratedAttribute(node, name, legalNames, -1, true);
    }

    private String getAttribute(Node node, String name, String defaultValue, boolean required) throws IIOInvalidTreeException {
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            this.fatal(node, "Required attribute " + name + " not present!");
        }
        return attr.getNodeValue();
    }

    private String getAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getAttribute(node, name, null, true);
    }
}

