/*
 * Decompiled with CFR 0.152.
 */
package de.pco.imageio;

import de.pco.common.MetadataBean;
import de.pco.common.SRGBColorCorrectionCoefficients;
import de.pco.common.Timestamp;
import de.pco.common.enums.B16Version;
import de.pco.common.enums.CameraSubtype;
import de.pco.common.enums.CameraSyncMode;
import de.pco.common.enums.CameraType;
import de.pco.common.enums.ColorPatternType;
import de.pco.common.enums.ImageTimeStatus;
import de.pco.common.enums.ImageType;
import de.pco.common.enums.SyncStatus;
import de.pco.common.enums.Timebase;
import de.pco.common.enums.TimestampPosition;
import de.pco.common.enums.TriggerMode;
import de.pco.imageio.B16ImageReaderSpi;
import de.pco.imageio.PcoIIOMetadata;
import de.pco.imageio.RawImageInputStream;
import de.pco.imageio.RawImageReader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

public class B16ImageReader
extends ImageReader {
    private ImageInputStream input;
    private RawImageReader delegate = new RawImageReader();
    private PcoIIOMetadata metadata;
    private boolean gotHeader = false;

    public B16ImageReader() {
        super(new B16ImageReaderSpi());
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input == null) {
            this.input = null;
            this.gotHeader = false;
            return;
        }
        if (!(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("input not an ImageInputStream!");
        }
        this.input = (ImageInputStream)input;
        this.gotHeader = false;
        this.input.setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int getNumImages(boolean allowSearch) {
        if (this.input == null) {
            throw new IllegalStateException("No input source set!");
        }
        if (this.seekForwardOnly && allowSearch) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        return 1;
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("input not an ImageInputStream!");
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.metadata.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.metadata.getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        ImageTypeSpecifier imageType = null;
        int datatype = 1;
        imageType = ImageTypeSpecifier.createGrayscale(16, datatype, false);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        l.add(imageType);
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.metadata;
    }

    private void readHeader() throws IOException {
        if (this.gotHeader) {
            return;
        }
        if (this.input == null) {
            throw new IllegalStateException("Input source not set!");
        }
        this.input.mark();
        this.input.skipBytes(4);
        int fileSize = this.input.readInt();
        int headerSize = this.input.readInt();
        int width = this.input.readInt();
        this.input.mark();
        this.input.mark();
        int height = this.input.readInt();
        boolean lookup = false;
        int testLookup = this.input.readInt();
        if (testLookup == -1) {
            lookup = true;
        }
        this.input.reset();
        this.input.skipBytes(52);
        boolean doubleShutter = false;
        int testDoubleShutter = this.input.readInt();
        if (testDoubleShutter == 21316) {
            doubleShutter = true;
        }
        MetadataBean metadataBean = null;
        if (headerSize >= 256) {
            this.input.reset();
            this.input.reset();
            this.input.skipBytes(128);
            metadataBean = B16ImageReader.loadMetadataFromBildStruct(this.input);
        } else {
            metadataBean = new MetadataBean();
            this.input.reset();
            metadataBean.xRes = width;
            metadataBean.yRes = height;
            if (headerSize >= 128 && lookup) {
                this.input.skipBytes(8);
                int testColor = this.input.readInt();
                metadataBean.isColor = testColor == 1;
                metadataBean.bwMin = this.input.readInt();
                metadataBean.bwMax = this.input.readInt();
                metadataBean.bwLut = this.input.readInt();
                metadataBean.rMin = this.input.readInt();
                metadataBean.rMax = this.input.readInt();
                metadataBean.gMin = this.input.readInt();
                metadataBean.gMax = this.input.readInt();
                metadataBean.bMin = this.input.readInt();
                metadataBean.bMax = this.input.readInt();
                metadataBean.colLut = this.input.readInt();
            } else {
                metadataBean.isColor = false;
                metadataBean.bwMin = 0;
                metadataBean.bwMax = 4095;
                metadataBean.bwLut = 0;
                metadataBean.rMin = 100;
                metadataBean.rMax = 4095;
                metadataBean.gMin = 0;
                metadataBean.gMax = 4095;
                metadataBean.bMin = 100;
                metadataBean.bMax = 4095;
                metadataBean.colLut = 0;
            }
            metadataBean.isDouble = doubleShutter;
            metadataBean.version = B16Version.UNDEFINED;
        }
        if (metadataBean.version.getValue() > B16Version.CURRENT.getValue() || metadataBean.version.getValue() <= B16Version.V100.getValue()) {
            metadataBean.xRes = 0;
            metadataBean.yRes = 0;
        }
        if (metadataBean.version.getValue() < B16Version.V200.getValue()) {
            metadataBean.bwMin2 = metadataBean.bwMin;
            metadataBean.bwMax2 = metadataBean.bwMax;
            metadataBean.bwLut2 = metadataBean.bwLut;
            metadataBean.rMin2 = metadataBean.rMin;
            metadataBean.rMax2 = metadataBean.rMax;
            metadataBean.gMin2 = metadataBean.gMin;
            metadataBean.gMax2 = metadataBean.gMax;
            metadataBean.bMin2 = metadataBean.bMin;
            metadataBean.bMax2 = metadataBean.bMax;
            metadataBean.colLut2 = metadataBean.colLut;
            metadataBean.alignUpper = false;
        }
        if (metadataBean.version.getValue() < B16Version.V300.getValue()) {
            metadataBean.gammaLut = 1.0;
            metadataBean.gammaLutC = 1.0;
            metadataBean.gammaLut2 = 1.0;
            metadataBean.gammaLutC2 = 1.0;
        }
        if (metadataBean.version.getValue() < B16Version.V301.getValue()) {
            metadataBean.bitRes = 14;
        }
        if (metadataBean.version.getValue() < B16Version.V302.getValue()) {
            metadataBean.dSaturation = 100.0;
            if (metadataBean.bitRes == 12) {
                metadataBean.alignUpper = false;
            }
        }
        if (metadataBean.version.getValue() < B16Version.V304.getValue()) {
            metadataBean.iSaturation = 0;
            metadataBean.vibrance = 0;
            metadataBean.colorTemp = 5000;
            metadataBean.colorTint = 0;
            metadataBean.contrast = 0;
            metadataBean.gamma = 100;
        }
        if (metadataBean.version.getValue() < B16Version.V305.getValue()) {
            SRGBColorCorrectionCoefficients ccc = new SRGBColorCorrectionCoefficients();
            ccc.a11 = 1.0;
            ccc.a12 = 0.0;
            ccc.a13 = 0.0;
            ccc.a21 = 0.0;
            ccc.a22 = 1.0;
            ccc.a23 = 0.0;
            ccc.a31 = 0.0;
            ccc.a32 = 0.0;
            ccc.a33 = 1.0;
            metadataBean.colorCoeff = ccc;
        }
        if (metadataBean.version.getValue() < B16Version.V306.getValue()) {
            metadataBean.timestampPosition = TimestampPosition.NONE;
            metadataBean.hasMetaData = false;
            metadataBean.sensorConvFactor = 0;
            metadataBean.cameraType = CameraType.UNDEFINED;
            metadataBean.darkOffset = 0;
            metadataBean.imageCounter = 0L;
            metadataBean.imageTimeUs = 0;
            metadataBean.imageTimeStatus = ImageTimeStatus.INTERNAL_OSC;
            metadataBean.exposureTimebase = Timebase.NS;
            metadataBean.sensorTemperature = Short.MIN_VALUE;
            metadataBean.exposureTime = 0L;
            metadataBean.framerateMilliHz = 0L;
            metadataBean.binningX = 0;
            metadataBean.binningY = 0;
            metadataBean.triggerMode = TriggerMode.AUTOTRIGGER;
            metadataBean.cameraSyncMode = CameraSyncMode.STANDALONE;
            metadataBean.sensorReadoutFrequency = 0L;
            metadataBean.cameraSerialNo = 0L;
        }
        if (metadataBean.version.getValue() < B16Version.V307.getValue()) {
            metadataBean.compression = 0L;
            metadataBean.compressionVersion = 0L;
            metadataBean.predictorStart = 0L;
            metadataBean.randomStart = 0L;
            metadataBean.randomIndex = 0L;
        }
        if (metadataBean.version.getValue() < B16Version.V308.getValue() && metadataBean.colorTint < 0) {
            metadataBean.colorTint /= 2;
        }
        if (metadataBean.colorTemp < 1000 || metadataBean.colorTemp > 20000) {
            metadataBean.colorTemp = 6500;
        }
        double checkCol = 0.0;
        SRGBColorCorrectionCoefficients ccc = metadataBean.colorCoeff;
        checkCol += ccc.a11;
        checkCol += ccc.a12;
        checkCol += ccc.a13;
        checkCol += ccc.a21;
        checkCol += ccc.a22;
        checkCol += ccc.a23;
        checkCol += ccc.a31;
        checkCol += ccc.a32;
        if ((checkCol += ccc.a33) <= 0.0 || checkCol > 20.0) {
            ccc.a11 = 1.0;
            ccc.a12 = 0.0;
            ccc.a13 = 0.0;
            ccc.a21 = 0.0;
            ccc.a22 = 1.0;
            ccc.a23 = 0.0;
            ccc.a31 = 0.0;
            ccc.a32 = 0.0;
            ccc.a33 = 1.0;
            metadataBean.colorCoeff = ccc;
        }
        if (metadataBean.gamma < 40 || metadataBean.gamma > 250) {
            metadataBean.gamma = 100;
        }
        if (metadataBean.version.getValue() < B16Version.V402.getValue()) {
            metadataBean.thisIsT0 = false;
        }
        if (metadataBean.version.getValue() < B16Version.V405.getValue()) {
            metadataBean.weHaveT0 = false;
            metadataBean.diffToT0 = 0;
        }
        metadataBean.version = B16Version.CURRENT;
        if (metadataBean.xRes == 0 || metadataBean.yRes == 0) {
            metadataBean.xRes = width;
            metadataBean.yRes = height;
            metadataBean.bitRes = 16;
            metadataBean.alignUpper = false;
        }
        this.gotHeader = true;
        this.input.seek(headerSize);
        this.metadata = new PcoIIOMetadata(metadataBean);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        RawImageInputStream delegateInput = new RawImageInputStream(this.input, this.metadata.getWidth(), this.metadata.getHeight(), false);
        this.delegate.setInput(delegateInput);
        BufferedImage bi = this.delegate.read(imageIndex);
        return bi;
    }

    public static MetadataBean loadMetadataFromBildStruct(ImageInputStream stream) throws IOException {
        boolean changed = false;
        MetadataBean metadataBean = new MetadataBean();
        Timestamp time = new Timestamp();
        time.year = stream.readUnsignedShort();
        time.month = stream.readUnsignedShort();
        time.dayOfWeek = stream.readUnsignedShort();
        time.day = stream.readUnsignedShort();
        time.hour = stream.readUnsignedShort();
        time.minute = stream.readUnsignedShort();
        time.second = stream.readUnsignedShort();
        time.milliseconds = stream.readUnsignedShort();
        metadataBean.time = time;
        metadataBean.ticks = stream.readInt();
        metadataBean.xRes = stream.readInt();
        metadataBean.yRes = stream.readInt();
        StringBuilder s = new StringBuilder();
        int nextUByte = 0;
        for (int i = 0; i < 40; ++i) {
            nextUByte = stream.readUnsignedByte();
            if (nextUByte == 0) continue;
            s.append((char)nextUByte);
        }
        metadataBean.text = s.toString();
        metadataBean.isDouble = stream.readBoolean();
        metadataBean.thisIsT0 = stream.readBoolean();
        metadataBean.weHaveT0 = stream.readBoolean();
        stream.readByte();
        metadataBean.bwMin = stream.readInt();
        metadataBean.bwMax = stream.readInt();
        metadataBean.bwLut = stream.readInt();
        metadataBean.rMin = stream.readInt();
        metadataBean.rMax = stream.readInt();
        metadataBean.gMin = stream.readInt();
        metadataBean.gMax = stream.readInt();
        metadataBean.bMin = stream.readInt();
        metadataBean.bMax = stream.readInt();
        metadataBean.colLut = stream.readInt();
        int testColor = stream.readInt();
        metadataBean.isColor = testColor == 1;
        metadataBean.version = B16Version.valueOf(stream.readInt());
        metadataBean.bwMin2 = stream.readInt();
        metadataBean.bwMax2 = stream.readInt();
        metadataBean.bwLut2 = stream.readInt();
        metadataBean.rMin2 = stream.readInt();
        metadataBean.rMax2 = stream.readInt();
        metadataBean.gMin2 = stream.readInt();
        metadataBean.gMax2 = stream.readInt();
        metadataBean.bMin2 = stream.readInt();
        metadataBean.bMax2 = stream.readInt();
        metadataBean.colLut2 = stream.readInt();
        metadataBean.alignUpper = stream.readBoolean();
        stream.skipBytes(3);
        metadataBean.gammaLut = stream.readDouble();
        metadataBean.gammaLutC = stream.readDouble();
        metadataBean.gammaLut2 = stream.readDouble();
        metadataBean.gammaLutC2 = stream.readDouble();
        int testColorPatternType = stream.readInt();
        if (testColorPatternType < 0 || testColorPatternType > 3) {
            metadataBean.colorPatternType = ColorPatternType.RED;
            changed = true;
        } else {
            metadataBean.colorPatternType = ColorPatternType.values()[testColorPatternType];
        }
        metadataBean.bitRes = stream.readInt();
        if (metadataBean.bitRes < 0 || metadataBean.bitRes > 16) {
            metadataBean.bitRes = 16;
            changed = true;
        }
        metadataBean.dSaturation = stream.readDouble();
        metadataBean.iSaturation = stream.readInt();
        metadataBean.vibrance = stream.readInt();
        metadataBean.colorTemp = stream.readInt();
        metadataBean.colorTint = stream.readInt();
        metadataBean.contrast = stream.readInt();
        metadataBean.gamma = stream.readInt();
        SRGBColorCorrectionCoefficients ccc = new SRGBColorCorrectionCoefficients();
        ccc.a11 = stream.readDouble();
        ccc.a12 = stream.readDouble();
        ccc.a13 = stream.readDouble();
        ccc.a21 = stream.readDouble();
        ccc.a22 = stream.readDouble();
        ccc.a23 = stream.readDouble();
        ccc.a31 = stream.readDouble();
        ccc.a32 = stream.readDouble();
        ccc.a33 = stream.readDouble();
        metadataBean.colorCoeff = ccc;
        metadataBean.timestampPosition = TimestampPosition.valueOf(stream.readInt());
        metadataBean.hasMetaData = false;
        int testHasMetadata = stream.readUnsignedShort();
        if (testHasMetadata != 0) {
            metadataBean.hasMetaData = true;
        }
        metadataBean.sensorConvFactor = stream.readUnsignedShort();
        metadataBean.cameraType = CameraType.valueOf(stream.readUnsignedShort());
        metadataBean.darkOffset = stream.readUnsignedShort();
        int[] imageCounterBCD = new int[4];
        imageCounterBCD[3] = stream.readUnsignedByte();
        imageCounterBCD[2] = stream.readUnsignedByte();
        imageCounterBCD[1] = stream.readUnsignedByte();
        imageCounterBCD[0] = stream.readUnsignedByte();
        metadataBean.imageCounter = 0L;
        for (int bcdByte : imageCounterBCD) {
            metadataBean.imageCounter *= 100L;
            metadataBean.imageCounter += (long)(10 * (bcdByte >> 4));
            metadataBean.imageCounter += (long)(bcdByte & 0xF);
        }
        int[] imageTimeUsBCD = new int[3];
        imageTimeUsBCD[2] = stream.readUnsignedByte();
        imageTimeUsBCD[1] = stream.readUnsignedByte();
        imageTimeUsBCD[0] = stream.readUnsignedByte();
        metadataBean.imageTimeUs = 0;
        for (int bcdByte : imageTimeUsBCD) {
            metadataBean.imageTimeUs *= 100;
            metadataBean.imageTimeUs += 10 * (bcdByte >> 4);
            metadataBean.imageTimeUs += bcdByte & 0xF;
        }
        metadataBean.imageTimeStatus = ImageTimeStatus.valueOf(stream.readUnsignedByte());
        metadataBean.exposureTimebase = Timebase.valueOf(stream.readUnsignedShort());
        metadataBean.sensorTemperature = stream.readShort();
        metadataBean.exposureTime = stream.readUnsignedInt();
        metadataBean.framerateMilliHz = stream.readUnsignedInt();
        int testBinningX = stream.readUnsignedByte();
        if (testBinningX < 0) {
            metadataBean.binningX = 0;
            changed = true;
        } else if (testBinningX > 32) {
            metadataBean.binningX = (byte)32;
            changed = true;
        } else {
            metadataBean.binningX = (byte)testBinningX;
        }
        int testBinningY = stream.readUnsignedByte();
        if (testBinningY < 0) {
            metadataBean.binningY = 0;
            changed = true;
        } else if (testBinningY > 32) {
            metadataBean.binningY = (byte)32;
            changed = true;
        } else {
            metadataBean.binningY = (byte)testBinningY;
        }
        int triggerModeTest = stream.readUnsignedByte();
        if (triggerModeTest < 0 || triggerModeTest > 100) {
            metadataBean.triggerMode = TriggerMode.AUTOTRIGGER;
            changed = true;
        } else {
            metadataBean.triggerMode = TriggerMode.valueOf(triggerModeTest);
        }
        int testCameraSyncMode = stream.readUnsignedByte();
        if (testCameraSyncMode < 0) {
            metadataBean.cameraSyncMode = CameraSyncMode.STANDALONE;
            changed = true;
        } else if (testCameraSyncMode > 100) {
            metadataBean.cameraSyncMode = CameraSyncMode.SLAVE;
            changed = true;
        } else {
            metadataBean.cameraSyncMode = CameraSyncMode.valueOf(testCameraSyncMode);
        }
        metadataBean.sensorReadoutFrequency = stream.readUnsignedInt();
        metadataBean.cameraSerialNo = stream.readUnsignedInt();
        int testSyncStatus = stream.readUnsignedByte();
        if (testSyncStatus < 0 || testSyncStatus > 100) {
            metadataBean.syncStatus = SyncStatus.OFF;
            changed = true;
        } else {
            metadataBean.syncStatus = SyncStatus.valueOf(testSyncStatus);
        }
        int testImageType = stream.readUnsignedByte();
        if (testImageType < 0) {
            metadataBean.imageType = ImageType.BW;
            changed = true;
        } else if (testImageType > 100) {
            metadataBean.imageType = ImageType.RGB;
            changed = true;
        } else {
            metadataBean.imageType = ImageType.valueOf(testImageType);
        }
        metadataBean.colorPattern = stream.readUnsignedShort();
        metadataBean.cameraSubtype = CameraSubtype.valueOf(stream.readUnsignedShort(), metadataBean.cameraType);
        stream.skipBytes(2);
        metadataBean.eventNumber = stream.readUnsignedInt();
        metadataBean.imageSizeXoffset = stream.readUnsignedShort();
        metadataBean.imageSizeYoffset = stream.readUnsignedShort();
        stream.skipBytes(64);
        metadataBean.compression = stream.readUnsignedInt();
        metadataBean.compressionVersion = stream.readUnsignedInt();
        metadataBean.predictorStart = stream.readUnsignedInt();
        metadataBean.randomStart = stream.readUnsignedInt();
        metadataBean.randomIndex = stream.readUnsignedInt();
        metadataBean.diffToT0 = stream.readInt();
        if (changed) {
            metadataBean.text = "SETTINGS ADAPTED DUE TO WRONG VALUES!";
        }
        return metadataBean;
    }
}

