/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common.enums;

import de.pco.common.MetadataBean;
import de.pco.common.enums.B16Version;
import de.pco.common.enums.CameraSubtype;
import de.pco.common.enums.CameraSyncMode;
import de.pco.common.enums.CameraType;
import de.pco.common.enums.ColorPatternType;
import de.pco.common.enums.ImageTimeStatus;
import de.pco.common.enums.ImageType;
import de.pco.common.enums.SyncStatus;
import de.pco.common.enums.Timebase;
import de.pco.common.enums.TimestampPosition;
import de.pco.common.enums.TriggerMode;
import java.util.Arrays;
import java.util.List;

public enum MetadataField {
    TIME_YEAR,
    TIME_MONTH,
    TIME_DAY_OF_WEEK,
    TIME_DAY,
    TIME_HOUR,
    TIME_MINUTE,
    TIME_SECOND,
    TIME_MILLISECONDS,
    TICKS,
    X_RES,
    Y_RES,
    TEXT,
    IS_DOUBLE,
    THIS_IS_T0,
    WE_HAVE_T0,
    BW_MIN,
    BW_MAX,
    BW_LUT,
    R_MIN,
    R_MAX,
    G_MIN,
    G_MAX,
    B_MIN,
    B_MAX,
    COL_LUT,
    IS_COLOR,
    VERSION,
    BW_MIN2,
    BW_MAX2,
    BW_LUT2,
    R_MIN2,
    R_MAX2,
    G_MIN2,
    G_MAX2,
    B_MIN2,
    B_MAX2,
    COL_LUT2,
    ALIGN_UPPER,
    GAMMA_LUT,
    GAMMA_LUT_C,
    GAMMA_LUT2,
    GAMMA_LUT_C2,
    COLOR_PATTERN_TYPE,
    BIT_RES,
    D_SATURATION,
    I_SATURATION,
    VIBRANCE,
    COLOR_TEMP,
    COLOR_TINT,
    CONTRAST,
    GAMMA,
    COLOR_COEFF_A11,
    COLOR_COEFF_A12,
    COLOR_COEFF_A13,
    COLOR_COEFF_A21,
    COLOR_COEFF_A22,
    COLOR_COEFF_A23,
    COLOR_COEFF_A31,
    COLOR_COEFF_A32,
    COLOR_COEFF_A33,
    TIMESTAMP_POSITION,
    HAS_METADATA,
    SENSOR_CONV_FACTOR,
    CAMERA_TYPE,
    DARK_OFFSET,
    IMAGE_COUNTER,
    IMAGE_TIME_US,
    IMAGE_TIME_STATUS,
    EXPOSURE_TIMEBASE,
    SENSOR_TEMPERATURE,
    EXPOSURE_TIME,
    FRAMERATE_MILLI_HZ,
    BINNING_X,
    BINNING_Y,
    TRIGGER_MODE,
    CAMERA_SYNC_MODE,
    SENSOR_READOUT_FREQUENCY,
    CAMERA_SERIAL_NO,
    SYNC_STATUS,
    IMAGE_TYPE,
    COLOR_PATTERN,
    CAMERA_SUBTYPE,
    EVENT_NUMBER,
    IMAGE_SIZE_X_OFFSET,
    IMAGE_SIZE_Y_OFFSET,
    COMPRESSION,
    COMPRESSION_VERSION,
    PREDICTOR_START,
    RANDOM_START,
    RANDOM_INDEX,
    DIFF_TO_T0;

    private static List<MetadataField> booleanFields;
    private static List<MetadataField> enumFields;
    private static List<MetadataField> wordMetadataFields;
    private static List<MetadataField> uIntMetadataFields;
    private static List<MetadataField> zeroMetadataFields;
    private static List<MetadataField> int100MetadataFields;
    private static List<MetadataField> double40MetadataFields;
    private static List<MetadataField> double3MetadataFields;
    private static List<MetadataField> specialMetadataFields;

    public static Comparable getMinValue(MetadataField enumValue) {
        if (wordMetadataFields.contains((Object)enumValue) || uIntMetadataFields.contains((Object)enumValue) || zeroMetadataFields.contains((Object)enumValue)) {
            return Integer.valueOf(0);
        }
        if (int100MetadataFields.contains((Object)enumValue)) {
            return Integer.valueOf(-100);
        }
        if (double40MetadataFields.contains((Object)enumValue)) {
            return Double.valueOf(40.0);
        }
        if (double3MetadataFields.contains((Object)enumValue)) {
            return Double.valueOf(-3.0);
        }
        if (specialMetadataFields.contains((Object)enumValue)) {
            switch (enumValue) {
                case BIT_RES: {
                    return Integer.valueOf(4);
                }
                case BINNING_X: 
                case BINNING_Y: {
                    return Integer.valueOf(1);
                }
                case DIFF_TO_T0: {
                    return Integer.valueOf(Integer.MIN_VALUE);
                }
                case SENSOR_TEMPERATURE: {
                    return Short.valueOf((short)Short.MIN_VALUE);
                }
                case TIME_MONTH: 
                case TIME_DAY_OF_WEEK: 
                case TIME_DAY: 
                case TIME_HOUR: 
                case TIME_MINUTE: 
                case TIME_SECOND: 
                case TIME_MILLISECONDS: {
                    return Integer.valueOf(0);
                }
                case COLOR_TEMP: {
                    return Integer.valueOf(3500);
                }
                case D_SATURATION: {
                    return Double.valueOf(-100.0);
                }
                case GAMMA: {
                    return Integer.valueOf(40);
                }
            }
        }
        return null;
    }

    public static Comparable getMaxValue(MetadataField enumValue) {
        if (wordMetadataFields.contains((Object)enumValue)) {
            return Integer.valueOf(65535);
        }
        if (uIntMetadataFields.contains((Object)enumValue)) {
            return Integer.valueOf(Integer.MAX_VALUE);
        }
        if (zeroMetadataFields.contains((Object)enumValue)) {
            return Integer.valueOf(0);
        }
        if (int100MetadataFields.contains((Object)enumValue)) {
            return Integer.valueOf(100);
        }
        if (double40MetadataFields.contains((Object)enumValue)) {
            return Double.valueOf(250.0);
        }
        if (double3MetadataFields.contains((Object)enumValue)) {
            return Double.valueOf(3.0);
        }
        if (specialMetadataFields.contains((Object)enumValue)) {
            switch (enumValue) {
                case BIT_RES: {
                    return Integer.valueOf(32);
                }
                case BINNING_X: 
                case BINNING_Y: {
                    return Integer.valueOf(32);
                }
                case DIFF_TO_T0: {
                    return Integer.valueOf(Integer.MAX_VALUE);
                }
                case SENSOR_TEMPERATURE: {
                    return Short.valueOf((short)Short.MAX_VALUE);
                }
                case TIME_MONTH: {
                    return Integer.valueOf(11);
                }
                case TIME_DAY_OF_WEEK: {
                    return Integer.valueOf(6);
                }
                case TIME_DAY: {
                    return Integer.valueOf(30);
                }
                case TIME_HOUR: {
                    return Integer.valueOf(23);
                }
                case TIME_MINUTE: 
                case TIME_SECOND: {
                    return Integer.valueOf(59);
                }
                case TIME_MILLISECONDS: {
                    return Integer.valueOf(999);
                }
                case COLOR_TEMP: {
                    return Integer.valueOf(20000);
                }
                case D_SATURATION: {
                    return Double.valueOf(100.0);
                }
                case GAMMA: {
                    return Integer.valueOf(250);
                }
            }
        }
        return null;
    }

    public static Object getDefaultValue(MetadataField enumValue) {
        if (wordMetadataFields.contains((Object)enumValue) || uIntMetadataFields.contains((Object)enumValue) || zeroMetadataFields.contains((Object)enumValue) || int100MetadataFields.contains((Object)enumValue)) {
            return 0;
        }
        if (double3MetadataFields.contains((Object)enumValue)) {
            return 0.0;
        }
        if (double40MetadataFields.contains((Object)enumValue)) {
            return 40.0;
        }
        if (specialMetadataFields.contains((Object)enumValue)) {
            switch (enumValue) {
                case BIT_RES: {
                    return 16;
                }
                case BINNING_X: 
                case BINNING_Y: {
                    return 1;
                }
                case DIFF_TO_T0: {
                    return 0;
                }
                case SENSOR_TEMPERATURE: {
                    return (short)Short.MIN_VALUE;
                }
                case TIME_MONTH: 
                case TIME_DAY_OF_WEEK: 
                case TIME_DAY: 
                case TIME_HOUR: 
                case TIME_MINUTE: 
                case TIME_SECOND: 
                case TIME_MILLISECONDS: {
                    return 0;
                }
                case COLOR_TEMP: {
                    return 3500;
                }
                case D_SATURATION: {
                    return 0.0;
                }
                case GAMMA: {
                    return 40;
                }
            }
        }
        return null;
    }

    public static Object getStepValue(MetadataField enumValue) {
        if (double40MetadataFields.contains((Object)enumValue) || double3MetadataFields.contains((Object)enumValue) || enumValue == D_SATURATION) {
            return 0.1;
        }
        return 1;
    }

    public static Object[] getEnumFieldValues(MetadataField enumValue) {
        switch (enumValue) {
            case VERSION: {
                return B16Version.values();
            }
            case TIMESTAMP_POSITION: {
                return TimestampPosition.values();
            }
            case COLOR_PATTERN_TYPE: {
                return ColorPatternType.values();
            }
            case CAMERA_TYPE: {
                return CameraType.values();
            }
            case IMAGE_TIME_STATUS: {
                return ImageTimeStatus.values();
            }
            case TRIGGER_MODE: {
                return TriggerMode.values();
            }
            case CAMERA_SYNC_MODE: {
                return CameraSyncMode.values();
            }
            case SYNC_STATUS: {
                return SyncStatus.values();
            }
            case IMAGE_TYPE: {
                return ImageType.values();
            }
            case CAMERA_SUBTYPE: {
                return CameraSubtype.values();
            }
            case EXPOSURE_TIMEBASE: {
                return Timebase.values();
            }
        }
        return null;
    }

    public static boolean isNumericField(MetadataField enumValue) {
        return !booleanFields.contains((Object)enumValue) && !enumFields.contains((Object)enumValue) && enumValue != TEXT;
    }

    public static boolean isTextField(MetadataField enumValue) {
        return enumValue == TEXT;
    }

    public static boolean isEnumField(MetadataField enumValue) {
        return enumFields.contains((Object)enumValue);
    }

    public static boolean isBooleanField(MetadataField enumValue) {
        return booleanFields.contains((Object)enumValue);
    }

    public static Object getValueOfField(MetadataBean metadata, MetadataField enumValue) {
        switch (enumValue) {
            case TIME_YEAR: {
                return metadata.time.year;
            }
            case TIME_MONTH: {
                return metadata.time.month;
            }
            case TIME_DAY_OF_WEEK: {
                return metadata.time.dayOfWeek;
            }
            case TIME_DAY: {
                return metadata.time.day;
            }
            case TIME_HOUR: {
                return metadata.time.hour;
            }
            case TIME_MINUTE: {
                return metadata.time.minute;
            }
            case TIME_SECOND: {
                return metadata.time.second;
            }
            case TIME_MILLISECONDS: {
                return metadata.time.milliseconds;
            }
            case TICKS: {
                return metadata.ticks;
            }
            case X_RES: {
                return metadata.xRes;
            }
            case Y_RES: {
                return metadata.yRes;
            }
            case TEXT: {
                return metadata.text;
            }
            case IS_DOUBLE: {
                return metadata.isDouble;
            }
            case THIS_IS_T0: {
                return metadata.thisIsT0;
            }
            case WE_HAVE_T0: {
                return metadata.weHaveT0;
            }
            case BW_MIN: {
                return metadata.bwMin;
            }
            case BW_MAX: {
                return metadata.bwMax;
            }
            case BW_LUT: {
                return metadata.bwLut;
            }
            case R_MIN: {
                return metadata.rMin;
            }
            case R_MAX: {
                return metadata.rMax;
            }
            case G_MIN: {
                return metadata.gMin;
            }
            case G_MAX: {
                return metadata.gMax;
            }
            case B_MIN: {
                return metadata.bMin;
            }
            case B_MAX: {
                return metadata.bMax;
            }
            case COL_LUT: {
                return metadata.colLut;
            }
            case IS_COLOR: {
                return metadata.isColor;
            }
            case VERSION: {
                return metadata.version;
            }
            case BW_MIN2: {
                return metadata.bwMin2;
            }
            case BW_MAX2: {
                return metadata.bwMax2;
            }
            case BW_LUT2: {
                return metadata.bwLut2;
            }
            case R_MIN2: {
                return metadata.rMin2;
            }
            case R_MAX2: {
                return metadata.rMax2;
            }
            case G_MIN2: {
                return metadata.gMin2;
            }
            case G_MAX2: {
                return metadata.gMax2;
            }
            case B_MIN2: {
                return metadata.bMin2;
            }
            case B_MAX2: {
                return metadata.bMax2;
            }
            case COL_LUT2: {
                return metadata.colLut;
            }
            case ALIGN_UPPER: {
                return metadata.alignUpper;
            }
            case GAMMA_LUT: {
                return metadata.gammaLut;
            }
            case GAMMA_LUT_C: {
                return metadata.gammaLutC;
            }
            case GAMMA_LUT2: {
                return metadata.gammaLut2;
            }
            case GAMMA_LUT_C2: {
                return metadata.gammaLutC2;
            }
            case COLOR_PATTERN_TYPE: {
                return metadata.colorPatternType;
            }
            case BIT_RES: {
                return metadata.bitRes;
            }
            case D_SATURATION: {
                return metadata.dSaturation;
            }
            case I_SATURATION: {
                return metadata.iSaturation;
            }
            case VIBRANCE: {
                return metadata.vibrance;
            }
            case COLOR_TEMP: {
                return metadata.colorTemp;
            }
            case COLOR_TINT: {
                return metadata.colorTint;
            }
            case CONTRAST: {
                return metadata.contrast;
            }
            case GAMMA: {
                return metadata.gamma;
            }
            case COLOR_COEFF_A11: {
                return metadata.colorCoeff.a11;
            }
            case COLOR_COEFF_A12: {
                return metadata.colorCoeff.a12;
            }
            case COLOR_COEFF_A13: {
                return metadata.colorCoeff.a13;
            }
            case COLOR_COEFF_A21: {
                return metadata.colorCoeff.a21;
            }
            case COLOR_COEFF_A22: {
                return metadata.colorCoeff.a22;
            }
            case COLOR_COEFF_A23: {
                return metadata.colorCoeff.a23;
            }
            case COLOR_COEFF_A31: {
                return metadata.colorCoeff.a31;
            }
            case COLOR_COEFF_A32: {
                return metadata.colorCoeff.a32;
            }
            case COLOR_COEFF_A33: {
                return metadata.colorCoeff.a33;
            }
            case TIMESTAMP_POSITION: {
                return metadata.timestampPosition;
            }
            case HAS_METADATA: {
                return metadata.hasMetaData;
            }
            case CAMERA_TYPE: {
                return metadata.cameraType;
            }
            case SENSOR_CONV_FACTOR: {
                return metadata.sensorConvFactor;
            }
            case DARK_OFFSET: {
                return metadata.darkOffset;
            }
            case IMAGE_COUNTER: {
                return metadata.imageCounter;
            }
            case IMAGE_TIME_US: {
                return metadata.imageTimeUs;
            }
            case IMAGE_TIME_STATUS: {
                return metadata.imageTimeStatus;
            }
            case EXPOSURE_TIMEBASE: {
                return metadata.exposureTimebase;
            }
            case SENSOR_TEMPERATURE: {
                return metadata.sensorTemperature;
            }
            case EXPOSURE_TIME: {
                return metadata.exposureTime;
            }
            case FRAMERATE_MILLI_HZ: {
                return metadata.framerateMilliHz;
            }
            case BINNING_X: {
                return metadata.binningX;
            }
            case BINNING_Y: {
                return metadata.binningY;
            }
            case TRIGGER_MODE: {
                return metadata.triggerMode;
            }
            case CAMERA_SYNC_MODE: {
                return metadata.cameraSyncMode;
            }
            case SENSOR_READOUT_FREQUENCY: {
                return metadata.sensorReadoutFrequency;
            }
            case CAMERA_SERIAL_NO: {
                return metadata.cameraSerialNo;
            }
            case SYNC_STATUS: {
                return metadata.syncStatus;
            }
            case IMAGE_TYPE: {
                return metadata.imageType;
            }
            case COLOR_PATTERN: {
                return metadata.colorPattern;
            }
            case CAMERA_SUBTYPE: {
                return metadata.cameraSubtype;
            }
            case EVENT_NUMBER: {
                return metadata.eventNumber;
            }
            case IMAGE_SIZE_X_OFFSET: {
                return metadata.imageSizeXoffset;
            }
            case IMAGE_SIZE_Y_OFFSET: {
                return metadata.imageSizeYoffset;
            }
            case COMPRESSION: {
                return metadata.compression;
            }
            case COMPRESSION_VERSION: {
                return metadata.compressionVersion;
            }
            case PREDICTOR_START: {
                return metadata.predictorStart;
            }
            case RANDOM_START: {
                return metadata.randomStart;
            }
            case RANDOM_INDEX: {
                return metadata.randomIndex;
            }
            case DIFF_TO_T0: {
                return metadata.diffToT0;
            }
        }
        throw new IllegalArgumentException("illegal MetadataField constant");
    }

    public static void setValueOfField(MetadataBean metadata, MetadataField field, Object value) {
        switch (field) {
            case TIME_YEAR: {
                metadata.time.year = (Integer)value;
                break;
            }
            case TIME_MONTH: {
                metadata.time.month = (Integer)value;
                break;
            }
            case TIME_DAY_OF_WEEK: {
                metadata.time.dayOfWeek = (Integer)value;
                break;
            }
            case TIME_DAY: {
                metadata.time.day = (Integer)value;
                break;
            }
            case TIME_HOUR: {
                metadata.time.hour = (Integer)value;
                break;
            }
            case TIME_MINUTE: {
                metadata.time.minute = (Integer)value;
                break;
            }
            case TIME_SECOND: {
                metadata.time.second = (Integer)value;
                break;
            }
            case TIME_MILLISECONDS: {
                metadata.time.milliseconds = (Integer)value;
                break;
            }
            case TICKS: {
                metadata.ticks = (Integer)value;
                break;
            }
            case X_RES: {
                metadata.xRes = (Integer)value;
                break;
            }
            case Y_RES: {
                metadata.yRes = (Integer)value;
                break;
            }
            case TEXT: {
                metadata.text = (String)value;
                break;
            }
            case IS_DOUBLE: {
                metadata.isDouble = (Boolean)value;
                break;
            }
            case THIS_IS_T0: {
                metadata.thisIsT0 = (Boolean)value;
                break;
            }
            case WE_HAVE_T0: {
                metadata.weHaveT0 = (Boolean)value;
                break;
            }
            case BW_MIN: {
                metadata.bwMin = (Integer)value;
                break;
            }
            case BW_MAX: {
                metadata.bwMax = (Integer)value;
                break;
            }
            case BW_LUT: {
                metadata.bwLut = (Integer)value;
                break;
            }
            case R_MIN: {
                metadata.rMin = (Integer)value;
                break;
            }
            case R_MAX: {
                metadata.rMax = (Integer)value;
                break;
            }
            case G_MIN: {
                metadata.gMin = (Integer)value;
                break;
            }
            case G_MAX: {
                metadata.gMax = (Integer)value;
                break;
            }
            case B_MIN: {
                metadata.bMin = (Integer)value;
                break;
            }
            case B_MAX: {
                metadata.bMax = (Integer)value;
                break;
            }
            case COL_LUT: {
                metadata.colLut = (Integer)value;
                break;
            }
            case IS_COLOR: {
                metadata.isColor = (Boolean)value;
                break;
            }
            case VERSION: {
                metadata.version = (B16Version)((Object)value);
                break;
            }
            case BW_MIN2: {
                metadata.bwMin2 = (Integer)value;
                break;
            }
            case BW_MAX2: {
                metadata.bwMax2 = (Integer)value;
                break;
            }
            case BW_LUT2: {
                metadata.bwLut2 = (Integer)value;
                break;
            }
            case R_MIN2: {
                metadata.rMin2 = (Integer)value;
                break;
            }
            case R_MAX2: {
                metadata.rMax2 = (Integer)value;
                break;
            }
            case G_MIN2: {
                metadata.gMin2 = (Integer)value;
                break;
            }
            case G_MAX2: {
                metadata.gMax2 = (Integer)value;
                break;
            }
            case B_MIN2: {
                metadata.bMin2 = (Integer)value;
                break;
            }
            case B_MAX2: {
                metadata.bMax2 = (Integer)value;
                break;
            }
            case COL_LUT2: {
                metadata.colLut = (Integer)value;
                break;
            }
            case ALIGN_UPPER: {
                metadata.alignUpper = (Boolean)value;
                break;
            }
            case GAMMA_LUT: {
                metadata.gammaLut = (Double)value;
                break;
            }
            case GAMMA_LUT_C: {
                metadata.gammaLutC = (Double)value;
                break;
            }
            case GAMMA_LUT2: {
                metadata.gammaLut2 = (Double)value;
                break;
            }
            case GAMMA_LUT_C2: {
                metadata.gammaLutC2 = (Double)value;
                break;
            }
            case COLOR_PATTERN_TYPE: {
                metadata.colorPatternType = (ColorPatternType)((Object)value);
                break;
            }
            case BIT_RES: {
                metadata.bitRes = (Integer)value;
                break;
            }
            case D_SATURATION: {
                metadata.dSaturation = (Double)value;
                break;
            }
            case I_SATURATION: {
                metadata.iSaturation = (Integer)value;
                break;
            }
            case VIBRANCE: {
                metadata.vibrance = (Integer)value;
                break;
            }
            case COLOR_TEMP: {
                metadata.colorTemp = (Integer)value;
                break;
            }
            case COLOR_TINT: {
                metadata.colorTint = (Integer)value;
                break;
            }
            case CONTRAST: {
                metadata.contrast = (Integer)value;
                break;
            }
            case GAMMA: {
                metadata.gamma = (Integer)value;
                break;
            }
            case COLOR_COEFF_A11: {
                metadata.colorCoeff.a11 = (Double)value;
                break;
            }
            case COLOR_COEFF_A12: {
                metadata.colorCoeff.a12 = (Double)value;
                break;
            }
            case COLOR_COEFF_A13: {
                metadata.colorCoeff.a13 = (Double)value;
                break;
            }
            case COLOR_COEFF_A21: {
                metadata.colorCoeff.a21 = (Double)value;
                break;
            }
            case COLOR_COEFF_A22: {
                metadata.colorCoeff.a22 = (Double)value;
                break;
            }
            case COLOR_COEFF_A23: {
                metadata.colorCoeff.a23 = (Double)value;
                break;
            }
            case COLOR_COEFF_A31: {
                metadata.colorCoeff.a31 = (Double)value;
                break;
            }
            case COLOR_COEFF_A32: {
                metadata.colorCoeff.a32 = (Double)value;
                break;
            }
            case COLOR_COEFF_A33: {
                metadata.colorCoeff.a33 = (Double)value;
                break;
            }
            case TIMESTAMP_POSITION: {
                metadata.timestampPosition = (TimestampPosition)((Object)value);
                break;
            }
            case HAS_METADATA: {
                metadata.hasMetaData = (Boolean)value;
                break;
            }
            case CAMERA_TYPE: {
                metadata.cameraType = (CameraType)((Object)value);
                break;
            }
            case SENSOR_CONV_FACTOR: {
                metadata.sensorConvFactor = (Integer)value;
                break;
            }
            case DARK_OFFSET: {
                metadata.darkOffset = (Integer)value;
                break;
            }
            case IMAGE_COUNTER: {
                metadata.imageCounter = ((Integer)value).intValue();
                break;
            }
            case IMAGE_TIME_US: {
                metadata.imageTimeUs = (Integer)value;
                break;
            }
            case IMAGE_TIME_STATUS: {
                metadata.imageTimeStatus = (ImageTimeStatus)((Object)value);
                break;
            }
            case EXPOSURE_TIMEBASE: {
                metadata.exposureTimebase = (Timebase)((Object)value);
                break;
            }
            case SENSOR_TEMPERATURE: {
                metadata.sensorTemperature = (short)((Integer)value).intValue();
                break;
            }
            case EXPOSURE_TIME: {
                metadata.exposureTime = ((Integer)value).intValue();
                break;
            }
            case FRAMERATE_MILLI_HZ: {
                metadata.framerateMilliHz = ((Integer)value).intValue();
                break;
            }
            case BINNING_X: {
                metadata.binningX = (byte)((Integer)value).intValue();
                break;
            }
            case BINNING_Y: {
                metadata.binningY = (byte)((Integer)value).intValue();
                break;
            }
            case TRIGGER_MODE: {
                metadata.triggerMode = (TriggerMode)((Object)value);
                break;
            }
            case CAMERA_SYNC_MODE: {
                metadata.cameraSyncMode = (CameraSyncMode)((Object)value);
                break;
            }
            case SENSOR_READOUT_FREQUENCY: {
                metadata.sensorReadoutFrequency = ((Integer)value).intValue();
                break;
            }
            case CAMERA_SERIAL_NO: {
                metadata.cameraSerialNo = ((Integer)value).intValue();
                break;
            }
            case SYNC_STATUS: {
                metadata.syncStatus = (SyncStatus)((Object)value);
                break;
            }
            case IMAGE_TYPE: {
                metadata.imageType = (ImageType)((Object)value);
                break;
            }
            case COLOR_PATTERN: {
                metadata.colorPattern = (Integer)value;
                break;
            }
            case CAMERA_SUBTYPE: {
                metadata.cameraSubtype = (CameraSubtype)((Object)value);
                break;
            }
            case EVENT_NUMBER: {
                metadata.eventNumber = ((Integer)value).intValue();
                break;
            }
            case IMAGE_SIZE_X_OFFSET: {
                metadata.imageSizeXoffset = (Integer)value;
                break;
            }
            case IMAGE_SIZE_Y_OFFSET: {
                metadata.imageSizeYoffset = (Integer)value;
                break;
            }
            case COMPRESSION: {
                metadata.compression = ((Integer)value).intValue();
                break;
            }
            case COMPRESSION_VERSION: {
                metadata.compressionVersion = ((Integer)value).intValue();
                break;
            }
            case PREDICTOR_START: {
                metadata.predictorStart = ((Integer)value).intValue();
                break;
            }
            case RANDOM_START: {
                metadata.randomStart = ((Integer)value).intValue();
                break;
            }
            case RANDOM_INDEX: {
                metadata.randomIndex = ((Integer)value).intValue();
                break;
            }
            case DIFF_TO_T0: {
                metadata.diffToT0 = (Integer)value;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal MetadataField constant");
            }
        }
    }

    static {
        booleanFields = Arrays.asList(IS_DOUBLE, THIS_IS_T0, WE_HAVE_T0, IS_COLOR, ALIGN_UPPER, HAS_METADATA);
        enumFields = Arrays.asList(VERSION, TIMESTAMP_POSITION, COLOR_PATTERN_TYPE, CAMERA_TYPE, IMAGE_TIME_STATUS, TRIGGER_MODE, CAMERA_SYNC_MODE, SYNC_STATUS, IMAGE_TYPE, CAMERA_SUBTYPE, EXPOSURE_TIMEBASE);
        wordMetadataFields = Arrays.asList(TIME_YEAR, TIME_MILLISECONDS, X_RES, Y_RES, BW_MIN, BW_MAX, BW_MIN2, BW_MAX2, R_MIN, R_MAX, R_MIN2, R_MAX2, G_MIN, G_MAX, G_MIN2, G_MAX2, B_MIN, B_MAX, B_MIN2, B_MAX2, SENSOR_CONV_FACTOR, DARK_OFFSET, COLOR_PATTERN, IMAGE_SIZE_X_OFFSET, IMAGE_SIZE_Y_OFFSET);
        uIntMetadataFields = Arrays.asList(TICKS, IMAGE_COUNTER, IMAGE_TIME_US, EXPOSURE_TIME, FRAMERATE_MILLI_HZ, SENSOR_READOUT_FREQUENCY, CAMERA_SERIAL_NO, EVENT_NUMBER, COMPRESSION, COMPRESSION_VERSION, RANDOM_START);
        zeroMetadataFields = Arrays.asList(PREDICTOR_START, RANDOM_INDEX, COL_LUT, COL_LUT2, BW_LUT, BW_LUT2);
        int100MetadataFields = Arrays.asList(I_SATURATION, VIBRANCE, COLOR_TINT, CONTRAST);
        double40MetadataFields = Arrays.asList(GAMMA_LUT, GAMMA_LUT2, GAMMA_LUT_C, GAMMA_LUT_C2);
        double3MetadataFields = Arrays.asList(COLOR_COEFF_A11, COLOR_COEFF_A12, COLOR_COEFF_A13, COLOR_COEFF_A21, COLOR_COEFF_A22, COLOR_COEFF_A23, COLOR_COEFF_A31, COLOR_COEFF_A32, COLOR_COEFF_A33);
        specialMetadataFields = Arrays.asList(TEXT, BIT_RES, COLOR_TEMP, BINNING_X, BINNING_Y, DIFF_TO_T0, SENSOR_TEMPERATURE, TIME_MONTH, TIME_DAY_OF_WEEK, TIME_DAY, TIME_HOUR, TIME_MINUTE, TIME_SECOND, D_SATURATION, GAMMA);
    }
}

