/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common;

import de.pco.common.SRGBColorCorrectionCoefficients;
import de.pco.common.Timestamp;
import de.pco.common.enums.B16Version;
import de.pco.common.enums.CameraSubtype;
import de.pco.common.enums.CameraSyncMode;
import de.pco.common.enums.CameraType;
import de.pco.common.enums.ColorPatternType;
import de.pco.common.enums.ImageTimeStatus;
import de.pco.common.enums.ImageType;
import de.pco.common.enums.SyncStatus;
import de.pco.common.enums.Timebase;
import de.pco.common.enums.TimestampPosition;
import de.pco.common.enums.TriggerMode;

public class MetadataBean {
    public Timestamp time = new Timestamp();
    public int ticks;
    public int xRes;
    public int yRes;
    public String text = "";
    public boolean isDouble;
    public boolean thisIsT0;
    public boolean weHaveT0;
    public int bwMin;
    public int bwMax;
    public int bwLut;
    public int rMin;
    public int rMax;
    public int gMin;
    public int gMax;
    public int bMin;
    public int bMax;
    public int colLut;
    public boolean isColor;
    public B16Version version = B16Version.UNDEFINED;
    public int bwMin2;
    public int bwMax2;
    public int bwLut2;
    public int rMin2;
    public int rMax2;
    public int gMin2;
    public int gMax2;
    public int bMin2;
    public int bMax2;
    public int colLut2;
    public boolean alignUpper;
    public double gammaLut = 40.0;
    public double gammaLutC = 40.0;
    public double gammaLut2 = 40.0;
    public double gammaLutC2 = 40.0;
    public ColorPatternType colorPatternType;
    public int bitRes = 16;
    public double dSaturation;
    public int iSaturation;
    public int vibrance;
    public int colorTemp = 3500;
    public int colorTint;
    public int contrast;
    public int gamma = 40;
    public SRGBColorCorrectionCoefficients colorCoeff = new SRGBColorCorrectionCoefficients();
    public TimestampPosition timestampPosition;
    public boolean hasMetaData;
    public int sensorConvFactor;
    public CameraType cameraType;
    public int darkOffset = 65535;
    public long imageCounter;
    public int imageTimeUs;
    public ImageTimeStatus imageTimeStatus;
    public Timebase exposureTimebase;
    public short sensorTemperature;
    public long exposureTime;
    public long framerateMilliHz;
    public byte binningX = 1;
    public byte binningY = 1;
    public TriggerMode triggerMode;
    public CameraSyncMode cameraSyncMode;
    public long sensorReadoutFrequency;
    public long cameraSerialNo;
    public SyncStatus syncStatus;
    public ImageType imageType;
    public int colorPattern;
    public CameraSubtype cameraSubtype;
    public long eventNumber;
    public int imageSizeXoffset;
    public int imageSizeYoffset;
    public long compression;
    public long compressionVersion;
    public long predictorStart;
    public long randomStart;
    public long randomIndex;
    public int diffToT0 = 0;

    public MetadataBean() {
        this.colorPatternType = ColorPatternType.values()[0];
        this.cameraType = CameraType.UNDEFINED;
        this.imageTimeStatus = ImageTimeStatus.INTERNAL_OSC;
        this.triggerMode = TriggerMode.AUTOTRIGGER;
        this.cameraSyncMode = CameraSyncMode.STANDALONE;
        this.syncStatus = SyncStatus.OFF;
        this.imageType = ImageType.UNDEFINED;
        this.cameraSubtype = CameraSubtype.UNDEFINED;
        this.sensorTemperature = Short.MIN_VALUE;
        this.timestampPosition = TimestampPosition.NONE;
        this.exposureTimebase = Timebase.NS;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alignUpper ? 1231 : 1237);
        result = 31 * result + this.bMax;
        result = 31 * result + this.bMax2;
        result = 31 * result + this.bMin;
        result = 31 * result + this.bMin2;
        result = 31 * result + this.binningX;
        result = 31 * result + this.binningY;
        result = 31 * result + this.bitRes;
        result = 31 * result + this.bwLut;
        result = 31 * result + this.bwLut2;
        result = 31 * result + this.bwMax;
        result = 31 * result + this.bwMax2;
        result = 31 * result + this.bwMin;
        result = 31 * result + this.bwMin2;
        result = 31 * result + (int)(this.cameraSerialNo ^ this.cameraSerialNo >>> 32);
        result = 31 * result + (this.cameraSubtype == null ? 0 : this.cameraSubtype.hashCode());
        result = 31 * result + (this.cameraSyncMode == null ? 0 : this.cameraSyncMode.hashCode());
        result = 31 * result + (this.cameraType == null ? 0 : this.cameraType.hashCode());
        result = 31 * result + this.colLut;
        result = 31 * result + this.colLut2;
        result = 31 * result + (this.colorCoeff == null ? 0 : this.colorCoeff.hashCode());
        result = 31 * result + this.colorPattern;
        result = 31 * result + (this.colorPatternType == null ? 0 : this.colorPatternType.hashCode());
        result = 31 * result + this.colorTemp;
        result = 31 * result + this.colorTint;
        result = 31 * result + (int)(this.compression ^ this.compression >>> 32);
        result = 31 * result + (int)(this.compressionVersion ^ this.compressionVersion >>> 32);
        result = 31 * result + this.contrast;
        long temp = Double.doubleToLongBits(this.dSaturation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.darkOffset;
        result = 31 * result + this.diffToT0;
        result = 31 * result + (int)(this.eventNumber ^ this.eventNumber >>> 32);
        result = 31 * result + (int)(this.exposureTime ^ this.exposureTime >>> 32);
        result = 31 * result + this.exposureTimebase.ordinal();
        result = 31 * result + (int)(this.framerateMilliHz ^ this.framerateMilliHz >>> 32);
        result = 31 * result + this.gMax;
        result = 31 * result + this.gMax2;
        result = 31 * result + this.gMin;
        result = 31 * result + this.gMin2;
        result = 31 * result + this.gamma;
        temp = Double.doubleToLongBits(this.gammaLut);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.gammaLut2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.gammaLutC);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.gammaLutC2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.hasMetaData ? 1231 : 1237);
        result = 31 * result + (this.timestampPosition == null ? 0 : this.timestampPosition.hashCode());
        result = 31 * result + this.iSaturation;
        result = 31 * result + (int)(this.imageCounter ^ this.imageCounter >>> 32);
        result = 31 * result + this.imageSizeXoffset;
        result = 31 * result + this.imageSizeYoffset;
        result = 31 * result + (this.imageTimeStatus == null ? 0 : this.imageTimeStatus.hashCode());
        result = 31 * result + this.imageTimeUs;
        result = 31 * result + (this.imageType == null ? 0 : this.imageType.hashCode());
        result = 31 * result + (this.isColor ? 1231 : 1237);
        result = 31 * result + (this.isDouble ? 1231 : 1237);
        result = 31 * result + (int)(this.predictorStart ^ this.predictorStart >>> 32);
        result = 31 * result + this.rMax;
        result = 31 * result + this.rMax2;
        result = 31 * result + this.rMin;
        result = 31 * result + this.rMin2;
        result = 31 * result + (int)(this.randomIndex ^ this.randomIndex >>> 32);
        result = 31 * result + (int)(this.randomStart ^ this.randomStart >>> 32);
        result = 31 * result + this.sensorConvFactor;
        result = 31 * result + (int)(this.sensorReadoutFrequency ^ this.sensorReadoutFrequency >>> 32);
        result = 31 * result + this.sensorTemperature;
        result = 31 * result + (this.syncStatus == null ? 0 : this.syncStatus.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.thisIsT0 ? 1231 : 1237);
        result = 31 * result + this.ticks;
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        result = 31 * result + (this.triggerMode == null ? 0 : this.triggerMode.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + this.vibrance;
        result = 31 * result + (this.weHaveT0 ? 1231 : 1237);
        result = 31 * result + this.xRes;
        result = 31 * result + this.yRes;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetadataBean other = (MetadataBean)obj;
        if (this.alignUpper != other.alignUpper) {
            return false;
        }
        if (this.bMax != other.bMax) {
            return false;
        }
        if (this.bMax2 != other.bMax2) {
            return false;
        }
        if (this.bMin != other.bMin) {
            return false;
        }
        if (this.bMin2 != other.bMin2) {
            return false;
        }
        if (this.binningX != other.binningX) {
            return false;
        }
        if (this.binningY != other.binningY) {
            return false;
        }
        if (this.bitRes != other.bitRes) {
            return false;
        }
        if (this.bwLut != other.bwLut) {
            return false;
        }
        if (this.bwLut2 != other.bwLut2) {
            return false;
        }
        if (this.bwMax != other.bwMax) {
            return false;
        }
        if (this.bwMax2 != other.bwMax2) {
            return false;
        }
        if (this.bwMin != other.bwMin) {
            return false;
        }
        if (this.bwMin2 != other.bwMin2) {
            return false;
        }
        if (this.cameraSerialNo != other.cameraSerialNo) {
            return false;
        }
        if (this.cameraSubtype != other.cameraSubtype) {
            return false;
        }
        if (this.cameraSyncMode != other.cameraSyncMode) {
            return false;
        }
        if (this.cameraType != other.cameraType) {
            return false;
        }
        if (this.colLut != other.colLut) {
            return false;
        }
        if (this.colLut2 != other.colLut2) {
            return false;
        }
        if (this.colorCoeff == null ? other.colorCoeff != null : !this.colorCoeff.equals(other.colorCoeff)) {
            return false;
        }
        if (this.colorPattern != other.colorPattern) {
            return false;
        }
        if (this.colorPatternType != other.colorPatternType) {
            return false;
        }
        if (this.colorTemp != other.colorTemp) {
            return false;
        }
        if (this.colorTint != other.colorTint) {
            return false;
        }
        if (this.compression != other.compression) {
            return false;
        }
        if (this.compressionVersion != other.compressionVersion) {
            return false;
        }
        if (this.contrast != other.contrast) {
            return false;
        }
        double EPSILON = 0.001;
        if ((double)Math.abs(Double.doubleToLongBits(this.dSaturation) - Double.doubleToLongBits(other.dSaturation)) >= 0.001) {
            return false;
        }
        if (this.darkOffset != other.darkOffset) {
            return false;
        }
        if (this.diffToT0 != other.diffToT0) {
            return false;
        }
        if (this.eventNumber != other.eventNumber) {
            return false;
        }
        if (this.exposureTime != other.exposureTime) {
            return false;
        }
        if (this.exposureTimebase != other.exposureTimebase) {
            return false;
        }
        if (this.framerateMilliHz != other.framerateMilliHz) {
            return false;
        }
        if (this.gMax != other.gMax) {
            return false;
        }
        if (this.gMax2 != other.gMax2) {
            return false;
        }
        if (this.gMin != other.gMin) {
            return false;
        }
        if (this.gMin2 != other.gMin2) {
            return false;
        }
        if (this.gamma != other.gamma) {
            return false;
        }
        if ((double)Math.abs(Double.doubleToLongBits(this.gammaLut) - Double.doubleToLongBits(other.gammaLut)) >= 0.001) {
            return false;
        }
        if ((double)Math.abs(Double.doubleToLongBits(this.gammaLut2) - Double.doubleToLongBits(other.gammaLut2)) >= 0.001) {
            return false;
        }
        if ((double)Math.abs(Double.doubleToLongBits(this.gammaLutC) - Double.doubleToLongBits(other.gammaLutC)) >= 0.001) {
            return false;
        }
        if ((double)Math.abs(Double.doubleToLongBits(this.gammaLutC2) - Double.doubleToLongBits(other.gammaLutC2)) >= 0.001) {
            return false;
        }
        if (this.hasMetaData != other.hasMetaData) {
            return false;
        }
        if (this.timestampPosition != other.timestampPosition) {
            return false;
        }
        if (this.iSaturation != other.iSaturation) {
            return false;
        }
        if (this.imageCounter != other.imageCounter) {
            return false;
        }
        if (this.imageSizeXoffset != other.imageSizeXoffset) {
            return false;
        }
        if (this.imageSizeYoffset != other.imageSizeYoffset) {
            return false;
        }
        if (this.imageTimeStatus != other.imageTimeStatus) {
            return false;
        }
        if (this.imageTimeUs != other.imageTimeUs) {
            return false;
        }
        if (this.imageType != other.imageType) {
            return false;
        }
        if (this.isColor != other.isColor) {
            return false;
        }
        if (this.isDouble != other.isDouble) {
            return false;
        }
        if (this.predictorStart != other.predictorStart) {
            return false;
        }
        if (this.rMax != other.rMax) {
            return false;
        }
        if (this.rMax2 != other.rMax2) {
            return false;
        }
        if (this.rMin != other.rMin) {
            return false;
        }
        if (this.rMin2 != other.rMin2) {
            return false;
        }
        if (this.randomIndex != other.randomIndex) {
            return false;
        }
        if (this.randomStart != other.randomStart) {
            return false;
        }
        if (this.sensorConvFactor != other.sensorConvFactor) {
            return false;
        }
        if (this.sensorReadoutFrequency != other.sensorReadoutFrequency) {
            return false;
        }
        if (this.sensorTemperature != other.sensorTemperature) {
            return false;
        }
        if (this.syncStatus != other.syncStatus) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        if (this.thisIsT0 != other.thisIsT0) {
            return false;
        }
        if (this.ticks != other.ticks) {
            return false;
        }
        if (this.time == null ? other.time != null : !this.time.equals(other.time)) {
            return false;
        }
        if (this.triggerMode != other.triggerMode) {
            return false;
        }
        if (this.version == B16Version.CURRENT && other.version != B16Version.CURRENT && other.version != B16Version.V405) {
            return false;
        }
        if (this.version == B16Version.V405 && other.version != B16Version.CURRENT && other.version != B16Version.V405) {
            return false;
        }
        if (this.version != B16Version.V405 && this.version != B16Version.CURRENT && this.version != other.version) {
            return false;
        }
        if (this.vibrance != other.vibrance) {
            return false;
        }
        if (this.weHaveT0 != other.weHaveT0) {
            return false;
        }
        if (this.xRes != other.xRes) {
            return false;
        }
        return this.yRes == other.yRes;
    }

    public String toString() {
        return "MetadataBean [time=" + this.time + ", ticks=" + this.ticks + ", xRes=" + this.xRes + ", yRes=" + this.yRes + ", text=" + this.text + ", isDouble=" + this.isDouble + ", thisIsT0=" + this.thisIsT0 + ", weHaveT0=" + this.weHaveT0 + ", bwMin=" + this.bwMin + ", bwMax=" + this.bwMax + ", bwLut=" + this.bwLut + ", rMin=" + this.rMin + ", rMax=" + this.rMax + ", gMin=" + this.gMin + ", gMax=" + this.gMax + ", bMin=" + this.bMin + ", bMax=" + this.bMax + ", colLut=" + this.colLut + ", isColor=" + this.isColor + ", version=" + (Object)((Object)this.version) + ", bwMin2=" + this.bwMin2 + ", bwMax2=" + this.bwMax2 + ", bwLut2=" + this.bwLut2 + ", rMin2=" + this.rMin2 + ", rMax2=" + this.rMax2 + ", gMin2=" + this.gMin2 + ", gMax2=" + this.gMax2 + ", bMin2=" + this.bMin2 + ", bMax2=" + this.bMax2 + ", colLut2=" + this.colLut2 + ", alignUpper=" + this.alignUpper + ", gammaLut=" + this.gammaLut + ", gammaLutC=" + this.gammaLutC + ", gammaLut2=" + this.gammaLut2 + ", gammaLutC2=" + this.gammaLutC2 + ", colorPatternType=" + (Object)((Object)this.colorPatternType) + ", bitRes=" + this.bitRes + ", dSaturation=" + this.dSaturation + ", iSaturation=" + this.iSaturation + ", vibrance=" + this.vibrance + ", colorTemp=" + this.colorTemp + ", colorTint=" + this.colorTint + ", contrast=" + this.contrast + ", gamma=" + this.gamma + ", colorCoeff=" + this.colorCoeff + ", timestampPosition=" + (Object)((Object)this.timestampPosition) + ", hasMetaData=" + this.hasMetaData + ", sensorConvFactor=" + this.sensorConvFactor + ", cameraType=" + (Object)((Object)this.cameraType) + ", darkOffset=" + this.darkOffset + ", imageCounter=" + this.imageCounter + ", imageTimeUs=" + this.imageTimeUs + ", imageTimeStatus=" + (Object)((Object)this.imageTimeStatus) + ", exposureTimeBase=" + (Object)((Object)this.exposureTimebase) + ", sensorTemperature=" + this.sensorTemperature + ", exposureTime=" + this.exposureTime + ", framerateMilliHz=" + this.framerateMilliHz + ", binningX=" + this.binningX + ", binningY=" + this.binningY + ", triggerMode=" + (Object)((Object)this.triggerMode) + ", cameraSyncMode=" + (Object)((Object)this.cameraSyncMode) + ", sensorReadoutFrequency=" + this.sensorReadoutFrequency + ", cameraSerialNo=" + this.cameraSerialNo + ", syncStatus=" + (Object)((Object)this.syncStatus) + ", imageType=" + (Object)((Object)this.imageType) + ", colorPattern=" + this.colorPattern + ", cameraSubtype=" + (Object)((Object)this.cameraSubtype) + ", eventNumber=" + this.eventNumber + ", imageSizeXoffset=" + this.imageSizeXoffset + ", imageSizeYoffset=" + this.imageSizeYoffset + ", compression=" + this.compression + ", compressionVersion=" + this.compressionVersion + ", predictorStart=" + this.predictorStart + ", randomStart=" + this.randomStart + ", randomIndex=" + this.randomIndex + ", diffToT0=" + this.diffToT0 + "]";
    }
}

