/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common;

import de.pco.common.AbstractMetadata;
import de.pco.common.AbstractUnsignedArray;
import java.io.InputStream;

public abstract class AbstractImageData {
    private int width;
    private int height;
    protected AbstractUnsignedArray image;
    private AbstractMetadata metadata;

    protected AbstractImageData(AbstractUnsignedArray image, int width, int height) {
        if (image == null) {
            throw new IllegalArgumentException("image can not be null");
        }
        this.image = image;
        this.width = width;
        this.height = height;
    }

    protected AbstractImageData(AbstractUnsignedArray image, AbstractMetadata metadata) {
        if (image == null) {
            throw new IllegalArgumentException("image can not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("metadata can not be null");
        }
        this.image = image;
        this.metadata = metadata;
        this.width = metadata.getImageSizeX();
        this.height = metadata.getImageSizeY();
    }

    protected AbstractImageData(int[] image, int width, int height) {
        if (image == null) {
            throw new IllegalArgumentException("image can not be null");
        }
        this.width = width;
        this.height = height;
    }

    public abstract boolean isCompressed();

    public int[] getData() {
        return this.image.getArray();
    }

    public abstract int getDataElementMaxValue();

    public abstract void setData(int[] var1);

    public AbstractMetadata getMetadata() {
        return this.metadata;
    }

    public InputStream getInputStream() {
        return this.image.getInputStream();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractImageData other = (AbstractImageData)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.image == null ? other.image != null : !this.image.equals(other.image)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        return this.width == other.width;
    }

    public String toString() {
        return "AbstractImageData [width=" + this.width + ", height=" + this.height + ", image=" + this.image + ", metadata=" + this.metadata + "]";
    }
}

