package de.pco.sdk.enums;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import java.util.Arrays;
import java.util.List;

/**
 * Enumerator of HW interfaces. 
 * Corresponds to the PCO_INTERFACE defines.  
 * @author PCO
 *
 */
public enum Interface 
{
    FW(1),  // obsolete       // Firewire interface
    CL_MTX(2),         // Cameralink Matrox Solios / Helios
    CL_ME3(3), //obsolete         // Cameralink Silicon Software Me3
    CL_NAT(4),          // Cameralink National Instruments
    GIGE(5),            // Gigabit Ethernet
    USB(6),             // USB 2.0
    CL_ME4(7),          // Cameralink Silicon Software Me4
    USB3(8),            // USB 3.0 and USB 3.1 Gen1
    WLAN(9),            // WLan (Only control path, not data path)
    CLHS(11),            // Cameralink HS
    UNDEFINED(0);
    
    private int value;
    
    /**
     * Constructor
     * @param value
     */
    Interface(int value) {
        this.value = value;
    }
    
    /**
     * Converter from the int value to the value of the enumerator.
     * @param value
     * @return
     * @throws IllegalArgumentException
     */
    public static Interface valueOf(int value) throws IllegalArgumentException 
    {
        for (Interface e : values()) {
            if (e.value == value) {
                return e;
            }
        }
        return UNDEFINED;
    }
    
    /**
     * Returns the list of these interfaces, common by the present cameras: GigE, CamLink ME4,
     * USB3, CLHS
     * @return
     */
    public static final List<Interface> commonInterfaceList()
    {
        return Arrays.asList(new Interface[] {Interface.GIGE, Interface.CL_ME4, Interface.USB3, Interface.CLHS});
    }
    
    
    /**
     * Getter
     * @return
     */
    public int getValue() {
        return value;
    }
}
