package de.pco.sdk.enums;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

/**
 * Enumerator of the camera internal INTERFACE_ defines. A particular value is returned by
 * the getCameraType method. 
 * @author PCO
 *
 */
public enum CameraInternalInterface 
{
    FIREWIRE(0x0001),
    CAMERALINK(0x0002),
    USB(0x0003),
    ETHERNET(0x0004),
    SERIAL(0x0005),
    USB3(0x0006),
    CAMERALINKHS(0x0007),
    COAXPRESS(0x0008),
    USB31_GEN1(0x0009),    
    UNDEFINED(0);
    
    private int value;
    
    /**
     * Constructor
     * @param value
     */
    CameraInternalInterface(int value) {
        this.value = value;
    }
    
    /**
     * Converter from the int value to the value of the enumerator.
     * @param value
     * @return
     * @throws IllegalArgumentException
     */
    public static CameraInternalInterface valueOf(int value) throws IllegalArgumentException 
    {
        for (CameraInternalInterface e : values()) {
            if (e.value == value) {
                return e;
            }
        }
        return UNDEFINED;
    }
    
    /**
     * Getter
     * @return
     */
    public int getValue() {
        return value;
    }
}
