package de.pco.sdk.enums;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

/**
 * Enumerator of the possible versions of the file B16.
 * @author PCO
 *
 */
public enum B16Version
{ 
    UNDEFINED(0),
    V100(100),
    V200(200),
    V300(300),
    V301(301),
    V302(302), // since 05.2005 / from CamWare 2.13
    V303(303), // since 04.2008 / from CamWare 2.21
    V304(304), // since 05.2009 / from CamWare 2.50
    V305(305), // since 07.2009 / from CamWare 2.50/3.00
    V306(306), // since 04.2010 / from CamWare 3.03
    V307(307), // since 03.2011 / from CamWare 3.05
    V308(308), // since 01.2012 / from CamWare 3.08
    V402(402), // since 03.2016 / from CamWare 4.02
    V405(405), // since 09.2017 / from CamWare 4.05
    CURRENT(405);
    
    private int value;
    
    /**
     * Constructor
     * @param value
     */
    B16Version(int value) {
        this.value = value;
    }
    
    /**
     * Converter from the int value to the value of the enumerator.
     * @param value
     * @return
     * @throws IllegalArgumentException
     */    
    public static B16Version valueOf(int value) 
    {
        for (B16Version e : values()) {
            if (e.value == value) {
                return e;
            }
        }
        return UNDEFINED;
        //throw new IllegalArgumentException("incorrect b16 file version constant number");
    }

    /**
     * Getter
     * @return
     */
    public int getValue() {
        return value;
    }
    
}
