package de.pco.common.enums;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

/**
 * Enumerator of the trigger modes
 * @author PCO
 *
 */
public enum TriggerMode 
{
    AUTOTRIGGER(0x00),
    SOFTWARETRIGGER(0x01),
    EXTERNALTRIGGER(0x02),
    EXTERNALEXPOSURECONTROL(0x03),
    EXTERNAL_SYNCHRONIZED(0x04),
    FAST_EXTERNALEXPOSURECONTROL(0x05),
    EXTERNAL_CDS(0x06),
    SLOW_EXTERNALEXPOSURECONTROL(0x07),
    AUTO_MULTICHANNEL(0x08);

    private int value;
    
    /**
     * Constructor
     * @param value
     */
    TriggerMode(int value) {
        this.value = value;
    }
    
    /**
     * Convertor from the int value to the value of the enumerator.
     * @param value
     * @return
     * @throws IllegalArgumentException
     */
    public static TriggerMode valueOf(int value) throws IllegalArgumentException 
    {
        for (TriggerMode e : values()) {
            if (e.value == value) {
                return e;
            }
        }
        throw new IllegalArgumentException("incorrect trigger mode constant number");
    }
    
    /**
     * Getter
     * @return
     */
    public int getValue() {
        return value;
    }
    
}
