package de.pco.common.enums;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

//From m_iColorPatternType;  
//Type of color pattern (upper left color)
// Bayer RGB: 0 upper left is red
//            1 upper left is green/red line
//            2 upper left is green/blue line
//            3 upper left is blue

/**
 * Enumerator of the demosaicking color pattern type
 * @author PCO
 *
 */
public enum ColorPatternType {
  RED (0),
  GREEN_RED_LINE (1),
  GREEN_BLUE_LINE (2),
  BLUE (3);
    
  private int value;
    
  /**
   * Constructor
   * @param value
   */
  ColorPatternType(int value) {
    this.value = value;
  }
  
  /**
   * Convertor from the int value to the value of the enumerator
   * @param value
   * @return
   * @throws IllegalArgumentException
   */
  public static ColorPatternType valueOf(int value) throws IllegalArgumentException 
  {
      for (ColorPatternType e : values()) {
          if (e.value == value) {
              return e;
          }
      }
      throw new IllegalArgumentException("incorrect color pattern type constant number");
  }
    
  /**
   * Getter
   * @return
   */
  public int getValue() {
      return value;
  } 

}
