package de.pco.common;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

/**
 * Class represents the image as unsigned byte[] and its metadata .
 * @author PCO
 *
 */
public class ImageDataCompressed extends AbstractImageData 
{
    /**
     * Constructor from the wrapped array of values, without the metadata.
     * @param image
     * @param width
     * @param height
     */
    public ImageDataCompressed(UByteArray image, int width, int height) {
        super(image, width, height);
    }
    
    /**
     * Constructor from the wrapped array of values and from the metadata which contains 
     * also the width and the height.
     * @param image
     * @param metadata
     */
    public ImageDataCompressed(UByteArray image, AbstractMetadata metadata) {
        super(image, metadata);
    }
    
    /** 
     * Constructor from the array of the real unsigned values. Wrapps the ints into 
     * {@link de.pco.common.UByteArray} by checking the maximal value which unsigned byte can hold.  
     * @param image
     * @param width
     * @param height
     */
    public ImageDataCompressed(int[] image, int width, int height)
    {
        super(image, width, height);
        this.image = new UByteArray(image);
    }

    /**
     * Returns always true because ImageData are based on UByteArray.
     */
    @Override
    public boolean isCompressed() {
        return true;
    }

    /**
     * Sets the image data. Checks the parameter whether all the data values fit in an unsigned byte.
     * @param data
     */
    @Override
    public void setData(int[] data) {
        this.image = new UByteArray(data);
    }
    
    /**
     * Returns the maximal value that can be stored in the returned data array: 
     * 255 which is the maximum of unsigned byte.  
     * @return
     */
    @Override
    public final int getDataElementMaxValue() {
        return UByteArray.ELEMENT_MAX_VALUE;
    }

}
