package de.pco.common;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

/**
 * Abstract class that represents the image metadata. Subclasses presents 
 * particular views on the {@link de.pco.common.MetadataBean} 
 * class which contains all the possible metadata of the images from PCO cameras. 
 * @author PCO
 *
 */
public abstract class AbstractMetadata 
{
    protected MetadataBean metadataBean;
    
    /**
     * Gets the width.
     * @return
     */
    public int getImageSizeX() {
        return metadataBean.xRes;
    }
    
    /**
     * Gets the height.
     * @return
     */
    public int getImageSizeY() {
        return metadataBean.yRes;
    }
    
    /**
     * Gets the whole backing bean with all the metadata.
     * @return
     */
    public MetadataBean getMetadataBean() {
        return this.metadataBean;
    }
    
    ////////////////////////////////////GENERATED

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((metadataBean == null) ? 0 : metadataBean.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AbstractMetadata other = (AbstractMetadata) obj;
        if (metadataBean == null) {
            if (other.metadataBean != null)
                return false;
        } else if (!metadataBean.equals(other.metadataBean))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return "AbstractMetadata [metadataBean=" + metadataBean + "]";
    }
}
