/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common;

import de.pco.common.UByteArray;
import de.pco.common.UShortArray;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UnsignedArrayTest {
    UnsignedArrayTest() {
    }

    @Test
    void testUByteArrayFromBytes() {
        byte[] byteArray = new byte[]{-1, -128, 127};
        UByteArray uByteArray = new UByteArray(byteArray);
        int[] intArray = uByteArray.getArray();
        Assertions.assertArrayEquals((int[])new int[]{255, 128, 127}, (int[])intArray);
        byte[] byteArray2 = uByteArray.getBackingArray();
        Assertions.assertArrayEquals((byte[])byteArray, (byte[])byteArray2);
        Assertions.assertEquals((int)255, (int)255);
    }

    @Test
    void testUByteArrayFromInts() {
        int[] intArray = new int[]{255, 128, 127};
        UByteArray uByteArray = new UByteArray(intArray);
        int[] intArray2 = uByteArray.getArray();
        Assertions.assertArrayEquals((int[])intArray, (int[])intArray2);
        byte[] byteArray = uByteArray.getBackingArray();
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -128, 127}, (byte[])byteArray);
    }

    @Test
    void testUByteArrayFromIntsErrors() {
        int[] intArray = new int[]{0, 0, 256};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UByteArray(intArray));
        int[] intArray1 = new int[]{-5, 0, 0};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UByteArray(intArray1));
        int[] intArray2 = new int[]{-305, 5555, 68};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UByteArray(intArray2));
    }

    @Test
    void testUShortArrayFromShorts() {
        short[] shortArray = new short[]{-1, Short.MIN_VALUE, 127};
        UShortArray uShortArray = new UShortArray(shortArray);
        int[] intArray = uShortArray.getArray();
        Assertions.assertArrayEquals((int[])new int[]{65535, 32768, 127}, (int[])intArray);
        short[] shortArray2 = uShortArray.getBackingArray();
        Assertions.assertArrayEquals((short[])shortArray, (short[])shortArray2);
        Assertions.assertEquals((int)65535, (int)65535);
    }

    @Test
    void testUShortArrayFromInts() {
        int[] intArray = new int[]{65535, 32768, 127};
        UShortArray uShortArray = new UShortArray(intArray);
        int[] intArray2 = uShortArray.getArray();
        Assertions.assertArrayEquals((int[])intArray, (int[])intArray2);
        short[] shortArray = uShortArray.getBackingArray();
        Assertions.assertArrayEquals((short[])new short[]{-1, Short.MIN_VALUE, 127}, (short[])shortArray);
    }

    @Test
    void testUShortArrayFromIntsErrors() {
        int[] intArray = new int[]{0, 0, 65536};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UShortArray(intArray));
        int[] intArray1 = new int[]{-5, 0, 0};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UShortArray(intArray1));
        int[] intArray2 = new int[]{66000, 5555, 68};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UShortArray(intArray2));
    }
}

