/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common;

import de.pco.common.ImageData;
import de.pco.common.ImageDataCompressed;
import de.pco.common.UByteArray;
import de.pco.common.UShortArray;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ImageDataTest {
    ImageDataTest() {
    }

    @Test
    void testCompression() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ImageDataCompressed(new UByteArray((byte[])null), 0, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ImageDataCompressed(new UByteArray((int[])null), 0, 0));
        ImageDataCompressed aid = new ImageDataCompressed(new UByteArray(new int[]{1, 2, 3}), 1400, 1200);
        Assertions.assertTrue((boolean)aid.isCompressed());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ImageData(new UShortArray((short[])null), 0, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ImageData(new UShortArray((int[])null), 0, 0));
        aid = new ImageData(new UShortArray(new int[]{1, 2, 3}), 1400, 1200);
        Assertions.assertFalse((boolean)aid.isCompressed());
    }

    @Test
    void testSetIntData() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ImageData(new int[]{5, 5, -5}, 0, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ImageData(new int[]{5, 5, 65536}, 0, 0));
        ImageData aid = new ImageData(new int[]{5, 5, 65535}, 1400, 1200);
        int[] retArray = aid.getData();
        Assertions.assertArrayEquals((int[])new int[]{5, 5, 65535}, (int[])retArray);
        retArray[2] = (retArray[0] + retArray[1] + retArray[2]) / 3;
        Assertions.assertArrayEquals((int[])new int[]{5, 5, 21848}, (int[])retArray);
        aid.setData(retArray);
        int[] retArray2 = aid.getData();
        Assertions.assertArrayEquals((int[])new int[]{5, 5, 21848}, (int[])retArray2);
        Assertions.assertEquals((int)65535, (int)aid.getDataElementMaxValue());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ImageDataCompressed(new int[]{5, 5, -3}, 0, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ImageDataCompressed(new int[]{5, 5, 256}, 0, 0));
        aid = new ImageDataCompressed(new int[]{5, 5, 254}, 1400, 1200);
        retArray = aid.getData();
        Assertions.assertArrayEquals((int[])new int[]{5, 5, 254}, (int[])retArray);
        retArray[2] = (retArray[0] + retArray[1] + retArray[2]) / 3;
        Assertions.assertArrayEquals((int[])new int[]{5, 5, 88}, (int[])retArray);
        aid.setData(retArray);
        retArray2 = aid.getData();
        Assertions.assertArrayEquals((int[])new int[]{5, 5, 88}, (int[])retArray2);
        Assertions.assertEquals((int)255, (int)aid.getDataElementMaxValue());
    }
}

