package de.pco.common;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */


import static org.junit.jupiter.api.Assertions.assertArrayEquals;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.junit.jupiter.api.Assertions.assertTrue;

import org.junit.jupiter.api.Test;



/**
 * Class to test the ImageData and ImageDataCompressed classes
 * @author PCO
 *
 */
class ImageDataTest 
{
    /**
     * Tests the isCompressed() method and the constructors to disallow null input parameter
     */
    @Test
    void testCompression() 
    {
        assertThrows(IllegalArgumentException.class, 
            () -> new ImageDataCompressed(new UByteArray((byte[])null),0,0));
        assertThrows(IllegalArgumentException.class, 
                () -> new ImageDataCompressed(new UByteArray((int[])null),0,0));
        AbstractImageData aid = new ImageDataCompressed(
            new UByteArray(new int[] {1, 2, 3}), 1400, 1200);
        assertTrue(aid.isCompressed());

        // the same for uncompressed
        assertThrows(IllegalArgumentException.class, 
            () -> new ImageData(new UShortArray((short[])null),0,0));
        assertThrows(IllegalArgumentException.class, 
            () -> new ImageData(new UShortArray((int[])null),0,0));
        aid = new ImageData (
            new UShortArray(new int[] {1, 2, 3}), 1400, 1200);
        assertFalse(aid.isCompressed());
    }
    
    /**
     * Tests the range check by constructing the class from an array of unsigned values of a subtype of int.
     */
    @Test 
    void testSetIntData() 
    {
        assertThrows(IllegalArgumentException.class, 
            () -> new ImageData(new int[] {5,5,-5},0,0));
        assertThrows(IllegalArgumentException.class, 
            () -> new ImageData(new int[] {5,5,65536},0,0));
        AbstractImageData aid = new ImageData(new int[] {5,5,65535}, 1400, 1200);
        int[] retArray = aid.getData();
        assertArrayEquals(new int[]{5,5,65535}, retArray);
        retArray[2] = (int)((retArray[0] + retArray[1] + retArray[2]) / 3); // we can count with the values
        assertArrayEquals(new int[]{5,5,21848}, retArray);
        aid.setData(retArray);
        int[] retArray2 = aid.getData();
        assertArrayEquals(new int[]{5,5,21848}, retArray2);
        assertEquals(65535, aid.getDataElementMaxValue());
        
        // the same for compressed
        assertThrows(IllegalArgumentException.class, 
            () -> new ImageDataCompressed(new int[] {5,5,-3},0,0));
        assertThrows(IllegalArgumentException.class, 
            () -> new ImageDataCompressed(new int[] {5,5,256},0,0));
        aid = new ImageDataCompressed(new int[] {5,5,254}, 1400, 1200);
        retArray = aid.getData();
        assertArrayEquals(new int[]{5,5,254}, retArray);
        retArray[2] = (int)((retArray[0] + retArray[1] + retArray[2]) / 3); // we can count with the values
        assertArrayEquals(new int[]{5,5,88}, retArray);
        aid.setData(retArray);
        retArray2 = aid.getData();
        assertArrayEquals(new int[]{5,5,88}, retArray2);
        assertEquals(255, aid.getDataElementMaxValue());
    }

}
