/*
 * Decompiled with CFR 0.152.
 */
package de.paktosan;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class RunServerMojo
extends AbstractMojo {
    MavenProject project;
    private String version;
    private File path;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Process p;
        ProcessBuilder pb;
        if (Files.notExists(Paths.get("server", new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(Paths.get("server", new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create directory", (Exception)e);
            }
        }
        if (Files.notExists(Paths.get("server/" + this.version + ".jar", new String[0]), new LinkOption[0])) {
            if (Files.notExists(Paths.get("servers", new String[0]), new LinkOption[0])) {
                try {
                    Files.createDirectory(Paths.get("servers", new String[0]), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not create directory", (Exception)e);
                }
            }
            if (Files.notExists(Paths.get("servers/BuildTools.jar", new String[0]), new LinkOption[0])) {
                this.getLog().info((CharSequence)"Downloading Spigot BuildTools...");
                try {
                    FileUtils.copyURLToFile((URL)new URL("https://hub.spigotmc.org/jenkins/job/BuildTools/lastSuccessfulBuild/artifact/target/BuildTools.jar"), (File)new File("servers/BuildTools.jar"));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Oops", (Exception)e);
                }
            }
            String[] strings = this.version.split("-");
            this.getLog().info((CharSequence)"Building Spigot and CraftBukkit...");
            try {
                pb = new ProcessBuilder("java", "-jar", "BuildTools.jar", "-rev", strings[1]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                pb = new ProcessBuilder("java", "-jar", "BuildTools.jar");
            }
            pb.directory(new File(this.path.toString() + "/servers"));
            pb.inheritIO();
            try {
                p = pb.start();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Oops", (Exception)e);
            }
            while (p.isAlive()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new MojoExecutionException("Mum, i can\u00b4t sleep...", (Exception)e);
                }
            }
            if (p.exitValue() != 0) {
                throw new MojoFailureException("Other process derped!");
            }
            this.getLog().info((CharSequence)"Copying everything to server...");
            try {
                Files.copy(Paths.get("servers/" + this.version + ".jar", new String[0]), Paths.get("server/" + this.version + ".jar", new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Couldn\u00b4t copy the server!", (Exception)e);
            }
        }
        if (Files.notExists(Paths.get("server/plugins", new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(Paths.get("server/plugins", new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Couldn\u00b4t create plugin dir" + e);
            }
        }
        try {
            Files.copy(Paths.get(String.valueOf(this.project.getArtifact().getFile()), new String[0]), Paths.get("server/plugins/" + this.project.getArtifact().getArtifactId() + ".jar", new String[0]), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn\u00b4t copy plugin!" + e);
        }
        this.getLog().info((CharSequence)"Starting server...");
        pb = new ProcessBuilder("java", "-jar", this.version + ".jar");
        pb.directory(new File(this.path.toString() + "/server"));
        pb.inheritIO();
        try {
            p = pb.start();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Oops", (Exception)e);
        }
        while (p.isAlive()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Mum, i can\u00b4t sleep...", (Exception)e);
            }
        }
        if (p.exitValue() != 0) {
            throw new MojoFailureException("Other process derped!");
        }
        this.getLog().info((CharSequence)"We are done!");
    }
}

