/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.util;

import java.util.Properties;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class UpdatableProperty<T> {
    private final String key;
    private T value;
    private boolean dirty = false;

    public UpdatableProperty(String key) {
        this(key, null);
    }

    public UpdatableProperty(String key, T value) {
        if (key == null) {
            throw new NullPointerException("Key parameter may not be null!");
        }
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.dirty = !this.equalValues(this.value, value);
        this.value = value;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void undirty() {
        this.dirty = false;
    }

    public boolean putProperty(Properties props) {
        if (!this.isDirty()) {
            return false;
        }
        props.put(this.getKey(), this.checkNull(this.getValue()));
        return true;
    }

    private final boolean equalValues(T v1, T v2) {
        return v1 == null && v2 == null || v1 != null && v1.equals(v2);
    }

    private final String checkNull(T val) {
        return val == null ? "#nil" : val.toString();
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }
}

