/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.util;

import de.ovgu.dke.mocca.api.MoccaException;
import de.ovgu.dke.mocca.api.MoccaRuntime;
import de.ovgu.dke.mocca.api.command.Command;
import de.ovgu.dke.mocca.glue.GlueMoccaRuntimeImpl;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoccaHelper {
    static Log logger = LogFactory.getLog(MoccaHelper.class);
    private static MoccaRuntime defaultRuntime = null;

    private MoccaHelper() {
    }

    public static synchronized MoccaRuntime getDefaultRuntime() {
        if (defaultRuntime == null) {
            defaultRuntime = new GlueMoccaRuntimeImpl();
        }
        return defaultRuntime;
    }

    public static void addShutdownHook(final MoccaRuntime mocca) {
        if (mocca == null) {
            throw new NullPointerException("Mocca runtime argument must not be null!");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info((Object)"Disposing mocca runtime.");
                    mocca.dispose();
                }
                catch (MoccaException e) {
                    logger.warn((Object)("Error shutting down mocca: " + e.getMessage()), (Throwable)e);
                }
            }
        }));
    }

    public static Properties cmdParams2Props(Command cmd) {
        if (cmd == null) {
            throw new NullPointerException("The cmd parameter may not be null!");
        }
        Properties props = new Properties();
        for (String key : cmd.getParameters()) {
            props.put(key, cmd.getParameter(key));
        }
        return props;
    }
}

