/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.util;

import de.ovgu.dke.mocca.api.command.CommandHandler;
import de.ovgu.dke.mocca.api.command.CommandHandlerRegistry;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CommandHandlerSupport
implements CommandHandlerRegistry {
    private final Map<URI, CommandHandler> handlers = new HashMap<URI, CommandHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCommandHandler(CommandHandler hnd) {
        if (hnd == null) {
            throw new NullPointerException("The handler argument must not be null!");
        }
        Map<URI, CommandHandler> map = this.handlers;
        synchronized (map) {
            Collection<URI> commands = hnd.getAvailableCommands();
            if (commands != null) {
                for (URI command : commands) {
                    this.handlers.put(command, hnd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommandHandler(URI command) {
        if (command == null) {
            throw new NullPointerException("The command argument must not be null!");
        }
        Map<URI, CommandHandler> map = this.handlers;
        synchronized (map) {
            this.handlers.remove(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandHandler getCommandHandler(URI command) {
        if (command == null) {
            throw new NullPointerException("The command argument must not be null!");
        }
        Map<URI, CommandHandler> map = this.handlers;
        synchronized (map) {
            return this.handlers.get(command);
        }
    }
}

