/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.glue;

import de.ovgu.dke.glue.api.transport.Connection;
import de.ovgu.dke.glue.api.transport.Packet;
import de.ovgu.dke.glue.api.transport.PacketThread;
import de.ovgu.dke.glue.api.transport.Transport;
import de.ovgu.dke.glue.api.transport.TransportException;
import de.ovgu.dke.glue.api.transport.TransportFactory;
import de.ovgu.dke.glue.api.transport.TransportRegistry;
import de.ovgu.dke.mocca.api.MoccaException;
import de.ovgu.dke.mocca.api.MoccaRuntime;
import de.ovgu.dke.mocca.api.command.Command;
import de.ovgu.dke.mocca.api.command.CommandHandlerRegistry;
import de.ovgu.dke.mocca.api.context.Context;
import de.ovgu.dke.mocca.api.context.ContextConnectionListener;
import de.ovgu.dke.mocca.api.context.State;
import de.ovgu.dke.mocca.util.CommandHandlerSupport;
import de.ovgu.dke.mocca.util.ContextConnectionSupport;
import de.ovgu.dke.mocca.util.MoccaHelper;
import de.ovgu.dke.mocca.util.UpdatableState;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class GlueContextImpl
implements Context {
    private final TransportFactory transports;
    private URI peer = null;
    private Connection connection = null;
    private PacketThread thread = null;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final CommandHandlerSupport handlers = new CommandHandlerSupport();
    private final ContextConnectionSupport connectionListeners = new ContextConnectionSupport();

    public static GlueContextImpl create(TransportFactory transports, ContextConnectionListener listener) {
        GlueContextImpl ctx = new GlueContextImpl(transports);
        if (listener != null) {
            ctx.addContextConnectionListener(listener);
        }
        return ctx;
    }

    public static GlueContextImpl createFromPacketThread(PacketThread pt, ContextConnectionListener listener) {
        if (pt == null) {
            throw new NullPointerException("Packet Thread parameter may not be null!");
        }
        if (pt.getConnection() == null) {
            throw new NullPointerException("Packet thread has no connection!");
        }
        GlueContextImpl ctx = GlueContextImpl.create(TransportRegistry.getDefaultTransportFactory(), listener);
        ctx.thread = pt;
        ctx.connection = pt.getConnection();
        ctx.peer = pt.getConnection().getPeer();
        if (listener != null) {
            listener.contextConnected(ctx, ctx.peer);
            listener.contextDialogOpen(ctx, pt.toString());
        }
        return ctx;
    }

    private GlueContextImpl(TransportFactory transports) {
        if (transports == null) {
            throw new NullPointerException("Transports parameter may not be null!");
        }
        this.transports = transports;
    }

    private TransportFactory getTransports() {
        return this.transports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(URI peer) throws MoccaException {
        TransportFactory transportFactory = this.transports;
        synchronized (transportFactory) {
            if (peer == null) {
                this.disconnect();
                return;
            }
            try {
                Transport transport = this.getTransports().createTransport(peer);
                this.connection = transport.getConnection("http://dke.ovgu.de/mocca/core/CommandMessage");
                if (!this.connection.checkCapabilities()) {
                    throw new MoccaException("Cannot establish MOCCA communication with " + peer.toASCIIString());
                }
                this.peer = peer;
                this.connectionListeners.contextConnected(this, this.peer);
            }
            catch (TransportException e) {
                throw new MoccaException("Error creating GLUE transport: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws MoccaException {
        TransportFactory transportFactory = this.transports;
        synchronized (transportFactory) {
            if (this.thread != null) {
                this.connectionListeners.contextDialogClose(this, this.thread.toString());
                this.thread.dispose();
            }
            this.connection = null;
            this.connectionListeners.contextDisconnected(this, this.peer);
            this.peer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI getPeer() {
        TransportFactory transportFactory = this.transports;
        synchronized (transportFactory) {
            return this.peer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCommand(Command cmd) throws MoccaException {
        TransportFactory transportFactory = this.transports;
        synchronized (transportFactory) {
            if (this.connection == null) {
                throw new MoccaException("Context is not connected!");
            }
            try {
                if (this.thread == null) {
                    this.thread = this.connection.createThread(PacketThread.DEFAULT_HANDLER);
                    this.connectionListeners.contextDialogOpen(this, this.thread.toString());
                }
                this.thread.send((Object)cmd, Packet.Priority.DEFAULT);
            }
            catch (TransportException e) {
                throw new MoccaException("Error sending command via GLUE: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void putAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Set<String> getAttributes() {
        return this.attributes.keySet();
    }

    @Override
    public MoccaRuntime getRuntime() {
        return MoccaHelper.getDefaultRuntime();
    }

    @Override
    public CommandHandlerRegistry getCommandHandlerRegistry() {
        return this.handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State getState() throws MoccaException {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            Object _state = this.getAttribute("http://dke.ovgu.de/mocca/core/Context#state");
            if (_state != null && !(_state instanceof State)) {
                throw new MoccaException("The key http://dke.ovgu.de/mocca/core/Context#state did not provide a state object in this context, something else has been put there!");
            }
            if (_state == null) {
                _state = new UpdatableState();
                this.putAttribute("http://dke.ovgu.de/mocca/core/Context#state", _state);
            }
            return (State)_state;
        }
    }

    @Override
    public void addContextConnectionListener(ContextConnectionListener listener) {
        this.connectionListeners.addListener(listener);
    }

    @Override
    public void removeContextConnectoinListener(ContextConnectionListener listener) {
        this.connectionListeners.removeListener(listener);
    }
}

