/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.util;

import de.ovgu.dke.mocca.api.MoccaException;
import de.ovgu.dke.mocca.api.command.Command;
import de.ovgu.dke.mocca.api.context.Context;
import de.ovgu.dke.mocca.api.context.State;
import de.ovgu.dke.mocca.util.UpdatableProperty;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class UpdatableState
implements State {
    private final UpdatableProperty<String> text = new UpdatableProperty("http://dke.ovgu.de/mocca/core/state#text");
    private final UpdatableProperty<State.Lifecycle> lifecycle = new UpdatableProperty("http://dke.ovgu.de/mocca/core/state#lifecycle");
    private final UpdatableProperty<Integer> progress_min = new UpdatableProperty("http://dke.ovgu.de/mocca/core/state#min");
    private final UpdatableProperty<Integer> progress_max = new UpdatableProperty("http://dke.ovgu.de/mocca/core/state#max");
    private final UpdatableProperty<Integer> progress_current = new UpdatableProperty("http://dke.ovgu.de/mocca/core/state#current");
    private final UpdatableProperty<State.Severity> severity = new UpdatableProperty("http://dke.ovgu.de/mocca/core/state#severity");
    private final UpdatableProperty<String> trace = new UpdatableProperty("http://dke.ovgu.de/mocca/core/state#trace");

    @Override
    public synchronized String getText() {
        return this.text.getValue();
    }

    @Override
    public synchronized void setText(String text) {
        this.text.setValue(text);
    }

    @Override
    public synchronized State.Lifecycle getLifecycle() {
        return this.lifecycle.getValue();
    }

    @Override
    public synchronized void setLifecycle(State.Lifecycle lifecycle) {
        this.lifecycle.setValue(lifecycle);
    }

    @Override
    public synchronized Integer getMinProgress() {
        return this.progress_min.getValue();
    }

    @Override
    public synchronized void setMinProgress(Integer progress_min) {
        this.progress_min.setValue(progress_min);
    }

    @Override
    public synchronized Integer getMaxProgress() {
        return this.progress_max.getValue();
    }

    @Override
    public synchronized void setMaxProgress(Integer progress_max) {
        this.progress_max.setValue(progress_max);
    }

    @Override
    public synchronized Integer getCurrentProgress() {
        return this.progress_current.getValue();
    }

    @Override
    public synchronized void setCurrentProgress(Integer progress_current) {
        this.progress_current.setValue(progress_current);
    }

    @Override
    public synchronized State.Severity getSeverity() {
        return this.severity.getValue();
    }

    @Override
    public synchronized void setSeverity(State.Severity severity) {
        this.severity.setValue(severity);
    }

    @Override
    public synchronized String getTrace() {
        return this.trace.getValue();
    }

    @Override
    public synchronized void setTrace(String trace) {
        this.trace.setValue(trace);
    }

    protected synchronized boolean isDirty() {
        return this.lifecycle.isDirty() || this.progress_current.isDirty() || this.progress_max.isDirty() || this.progress_min.isDirty() || this.severity.isDirty() || this.text.isDirty() || this.trace.isDirty();
    }

    protected synchronized void undirty() {
        this.text.undirty();
        this.lifecycle.undirty();
        this.progress_min.undirty();
        this.progress_max.undirty();
        this.progress_current.undirty();
        this.severity.undirty();
        this.trace.undirty();
    }

    @Override
    public synchronized Command createStateUpdate(Context ctx) throws MoccaException {
        if (!this.isDirty()) {
            return null;
        }
        Properties props = new Properties();
        this.text.putProperty(props);
        this.lifecycle.putProperty(props);
        this.progress_min.putProperty(props);
        this.progress_max.putProperty(props);
        this.progress_current.putProperty(props);
        this.severity.putProperty(props);
        this.trace.putProperty(props);
        Command cmd = ctx.getRuntime().createCommand(State.CMD_UPDATE, props);
        this.undirty();
        return cmd;
    }
}

