/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.util;

import de.ovgu.dke.mocca.api.MoccaException;
import de.ovgu.dke.mocca.api.command.Command;
import de.ovgu.dke.mocca.api.context.Context;
import de.ovgu.dke.mocca.api.context.State;

public class ContextUtils {
    private static void sendStateUpdate(Context ctx) throws MoccaException {
        Command cmd = ctx.getState().createStateUpdate(ctx);
        if (cmd != null) {
            ctx.sendCommand(cmd);
        }
    }

    public static void sendProgress(Context ctx, State.Lifecycle lifecycle) throws MoccaException {
        State state = ctx.getState();
        state.setText(null);
        state.setTrace(null);
        state.setLifecycle(lifecycle);
        ContextUtils.sendStateUpdate(ctx);
    }

    public static void sendError(Context ctx, String cause, String msg) throws MoccaException {
        State state = ctx.getState();
        state.setLifecycle(State.Lifecycle.FAILED);
        state.setSeverity(State.Severity.FATAL);
        state.setText(cause);
        state.setTrace(msg);
        ContextUtils.sendStateUpdate(ctx);
    }

    public static Integer retrieveInteger(Context ctx, Command cmd, String key) throws NumberFormatException, MoccaException {
        try {
            String _i = cmd.getParameter(key);
            return _i == null ? null : Integer.valueOf(Integer.parseInt(_i));
        }
        catch (NumberFormatException nfe) {
            ContextUtils.sendError(ctx, "IllegalArgument", "NumberFormatException: " + nfe.getMessage());
            throw nfe;
        }
    }
}

